#!/bin/sh

readlink() {
	path=$1

	if [ -L "$path" ]
	then
		ls -l "$path" | sed 's/^.*-> //'
	else
		return 1
	fi
}

SCRIPT="$0"
COUNT=0
while [ -L "${SCRIPT}" ]
do
	SCRIPT=$(readlink ${SCRIPT})
	COUNT=$(expr ${COUNT} + 1)
	if [ ${COUNT} -gt 100 ]
	then
		echo "Too many symbolic links"
		exit 1
	fi
done
GAMEDIR=$(dirname "${SCRIPT}")

cd $GAMEDIR

if [ -e $GAMEDIR/useqt5 ]
then
  export LD_LIBRARY_PATH="./lib-qt5"
  ./openmw-essimporter-qt5.@ARCH@ "$@"
else
  export LD_LIBRARY_PATH="./lib"
  ./openmw-essimporter.@ARCH@ "$@"
fi
