/*
  Copyright (C) 2015-2020 cc9cii

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  cc9cii cc9c@iinet.net.au

  Much of the information on the data structures are based on the information
  from Tes4Mod:Mod_File_Format and Tes5Mod:File_Formats but also refined by
  trial & error.  See http://en.uesp.net/wiki for details.

*/
#ifndef ESM4_COMMON_H
#define ESM4_COMMON_H

#include "components/esm/fourcc.hpp"

namespace ESM4
{
    using ESM::fourCC;

    enum RecordTypes
    {
        REC_AACT = fourCC("AACT"), // Action
        REC_ACHR = fourCC("ACHR"), // Actor Reference
        REC_ACTI = fourCC("ACTI"), // Activator
        REC_ADDN = fourCC("ADDN"), // Addon Node
        REC_ALCH = fourCC("ALCH"), // Potion
        REC_AMMO = fourCC("AMMO"), // Ammo
        REC_ANIO = fourCC("ANIO"), // Animated Object
        REC_APPA = fourCC("APPA"), // Apparatus (probably unused)
        REC_ARMA = fourCC("ARMA"), // Armature (Model)
        REC_ARMO = fourCC("ARMO"), // Armor
        REC_ARTO = fourCC("ARTO"), // Art Object
        REC_ASPC = fourCC("ASPC"), // Acoustic Space
        REC_ASTP = fourCC("ASTP"), // Association Type
        REC_AVIF = fourCC("AVIF"), // Actor Values/Perk Tree Graphics
        REC_BOOK = fourCC("BOOK"), // Book
        REC_BPTD = fourCC("BPTD"), // Body Part Data
        REC_CAMS = fourCC("CAMS"), // Camera Shot
        REC_CELL = fourCC("CELL"), // Cell
        REC_CLAS = fourCC("CLAS"), // Class
        REC_CLFM = fourCC("CLFM"), // Color
        REC_CLMT = fourCC("CLMT"), // Climate
        REC_CLOT = fourCC("CLOT"), // Clothing
        REC_COBJ = fourCC("COBJ"), // Constructible Object (recipes)
        REC_COLL = fourCC("COLL"), // Collision Layer
        REC_CONT = fourCC("CONT"), // Container
        REC_CPTH = fourCC("CPTH"), // Camera Path
        REC_CREA = fourCC("CREA"), // Creature
        REC_CSTY = fourCC("CSTY"), // Combat Style
        REC_DEBR = fourCC("DEBR"), // Debris
        REC_DIAL = fourCC("DIAL"), // Dialog Topic
        REC_DLBR = fourCC("DLBR"), // Dialog Branch
        REC_DLVW = fourCC("DLVW"), // Dialog View
        REC_DOBJ = fourCC("DOBJ"), // Default Object Manager
        REC_DOOR = fourCC("DOOR"), // Door
        REC_DUAL = fourCC("DUAL"), // Dual Cast Data (possibly unused)
        REC_ECZN = fourCC("ECZN"), // Encounter Zone
        REC_EFSH = fourCC("EFSH"), // Effect Shader
        REC_ENCH = fourCC("ENCH"), // Enchantment
        REC_EQUP = fourCC("EQUP"), // Equip Slot (flag-type values)
        REC_EXPL = fourCC("EXPL"), // Explosion
        REC_EYES = fourCC("EYES"), // Eyes
        REC_FACT = fourCC("FACT"), // Faction
        REC_FLOR = fourCC("FLOR"), // Flora
        REC_FLST = fourCC("FLST"), // Form List (non-levelled list)
        REC_FSTP = fourCC("FSTP"), // Footstep
        REC_FSTS = fourCC("FSTS"), // Footstep Set
        REC_FURN = fourCC("FURN"), // Furniture
        REC_GLOB = fourCC("GLOB"), // Global Variable
        REC_GMST = fourCC("GMST"), // Game Setting
        REC_GRAS = fourCC("GRAS"), // Grass
        REC_GRUP = fourCC("GRUP"), // Form Group
        REC_HAIR = fourCC("HAIR"), // Hair
        REC_HAZD = fourCC("HAZD"), // Hazard
        REC_HDPT = fourCC("HDPT"), // Head Part
        REC_IDLE = fourCC("IDLE"), // Idle Animation
        REC_IDLM = fourCC("IDLM"), // Idle Marker
        REC_IMAD = fourCC("IMAD"), // Image Space Modifier
        REC_IMGS = fourCC("IMGS"), // Image Space
        REC_INFO = fourCC("INFO"), // Dialog Topic Info
        REC_INGR = fourCC("INGR"), // Ingredient
        REC_IPCT = fourCC("IPCT"), // Impact Data
        REC_IPDS = fourCC("IPDS"), // Impact Data Set
        REC_KEYM = fourCC("KEYM"), // Key
        REC_KYWD = fourCC("KYWD"), // Keyword
        REC_LAND = fourCC("LAND"), // Land
        REC_LCRT = fourCC("LCRT"), // Location Reference Type
        REC_LCTN = fourCC("LCTN"), // Location
        REC_LGTM = fourCC("LGTM"), // Lighting Template
        REC_LIGH = fourCC("LIGH"), // Light
        REC_LSCR = fourCC("LSCR"), // Load Screen
        REC_LTEX = fourCC("LTEX"), // Land Texture
        REC_LVLC = fourCC("LVLC"), // Leveled Creature
        REC_LVLI = fourCC("LVLI"), // Leveled Item
        REC_LVLN = fourCC("LVLN"), // Leveled Actor
        REC_LVSP = fourCC("LVSP"), // Leveled Spell
        REC_MATO = fourCC("MATO"), // Material Object
        REC_MATT = fourCC("MATT"), // Material Type
        REC_MESG = fourCC("MESG"), // Message
        REC_MGEF = fourCC("MGEF"), // Magic Effect
        REC_MISC = fourCC("MISC"), // Misc. Object
        REC_MOVT = fourCC("MOVT"), // Movement Type
        REC_MSTT = fourCC("MSTT"), // Movable Static
        REC_MUSC = fourCC("MUSC"), // Music Type
        REC_MUST = fourCC("MUST"), // Music Track
        REC_NAVI = fourCC("NAVI"), // Navigation (master data)
        REC_NAVM = fourCC("NAVM"), // Nav Mesh
        REC_NOTE = fourCC("NOTE"), // Note
        REC_NPC_ = fourCC("NPC_"), // Actor (NPC, Creature)
        REC_OTFT = fourCC("OTFT"), // Outfit
        REC_PACK = fourCC("PACK"), // AI Package
        REC_PERK = fourCC("PERK"), // Perk
        REC_PGRE = fourCC("PGRE"), // Placed grenade
        REC_PHZD = fourCC("PHZD"), // Placed hazard
        REC_PROJ = fourCC("PROJ"), // Projectile
        REC_QUST = fourCC("QUST"), // Quest
        REC_RACE = fourCC("RACE"), // Race / Creature type
        REC_REFR = fourCC("REFR"), // Object Reference
        REC_REGN = fourCC("REGN"), // Region (Audio/Weather)
        REC_RELA = fourCC("RELA"), // Relationship
        REC_REVB = fourCC("REVB"), // Reverb Parameters
        REC_RFCT = fourCC("RFCT"), // Visual Effect
        REC_SBSP = fourCC("SBSP"), // Subspace (TES4 only?)
        REC_SCEN = fourCC("SCEN"), // Scene
        REC_SCPT = fourCC("SCPT"), // Script
        REC_SCRL = fourCC("SCRL"), // Scroll
        REC_SGST = fourCC("SGST"), // Sigil Stone
        REC_SHOU = fourCC("SHOU"), // Shout
        REC_SLGM = fourCC("SLGM"), // Soul Gem
        REC_SMBN = fourCC("SMBN"), // Story Manager Branch Node
        REC_SMEN = fourCC("SMEN"), // Story Manager Event Node
        REC_SMQN = fourCC("SMQN"), // Story Manager Quest Node
        REC_SNCT = fourCC("SNCT"), // Sound Category
        REC_SNDR = fourCC("SNDR"), // Sound Reference
        REC_SOPM = fourCC("SOPM"), // Sound Output Model
        REC_SOUN = fourCC("SOUN"), // Sound
        REC_SPEL = fourCC("SPEL"), // Spell
        REC_SPGD = fourCC("SPGD"), // Shader Particle Geometry
        REC_STAT = fourCC("STAT"), // Static
        REC_TACT = fourCC("TACT"), // Talking Activator
        REC_TERM = fourCC("TERM"), // Terminal
        REC_TES4 = fourCC("TES4"), // Plugin info
        REC_TREE = fourCC("TREE"), // Tree
        REC_TXST = fourCC("TXST"), // Texture Set
        REC_VTYP = fourCC("VTYP"), // Voice Type
        REC_WATR = fourCC("WATR"), // Water Type
        REC_WEAP = fourCC("WEAP"), // Weapon
        REC_WOOP = fourCC("WOOP"), // Word Of Power
        REC_WRLD = fourCC("WRLD"), // World Space
        REC_WTHR = fourCC("WTHR"), // Weather
        REC_ACRE = fourCC("ACRE"), // Placed Creature (TES4 only?)
        REC_PGRD = fourCC("PGRD"), // Pathgrid (TES4 only?)
        REC_ROAD = fourCC("ROAD"), // Road (TES4 only?)
        REC_IMOD = fourCC("IMOD"), // Item Mod
        REC_PWAT = fourCC("PWAT"), // Placeable Water
        REC_SCOL = fourCC("SCOL"), // Static Collection
        REC_CCRD = fourCC("CCRD"), // Caravan Card
        REC_CMNY = fourCC("CMNY"), // Caravan Money
        REC_ALOC = fourCC("ALOC"), // Audio Location Controller
        REC_MSET = fourCC("MSET") // Media Set
    };

    enum SubRecordTypes
    {
        SUB_ACBS = fourCC("ACBS"),
        SUB_ACEC = fourCC("ACEC"), // TES5 Dawnguard
        SUB_ACEP = fourCC("ACEP"), // TES5 Dawnguard
        SUB_ACID = fourCC("ACID"), // TES5 Dawnguard
        SUB_ACPR = fourCC("ACPR"), // TES5
        SUB_ACSR = fourCC("ACSR"), // TES5 Dawnguard
        SUB_ACTV = fourCC("ACTV"), // FO4
        SUB_ACUN = fourCC("ACUN"), // TES5 Dawnguard
        SUB_AHCF = fourCC("AHCF"),
        SUB_AHCM = fourCC("AHCM"),
        SUB_AIDT = fourCC("AIDT"),
        SUB_ALCA = fourCC("ALCA"), // TES5
        SUB_ALCC = fourCC("ALCC"), // FO4
        SUB_ALCL = fourCC("ALCL"), // TES5
        SUB_ALCO = fourCC("ALCO"), // TES5
        SUB_ALCS = fourCC("ALCS"), // FO4
        SUB_ALDI = fourCC("ALDI"), // FO4
        SUB_ALDN = fourCC("ALDN"), // TES5
        SUB_ALEA = fourCC("ALEA"), // TES5
        SUB_ALED = fourCC("ALED"), // TES5
        SUB_ALEQ = fourCC("ALEQ"), // TES5
        SUB_ALFA = fourCC("ALFA"), // TES5
        SUB_ALFC = fourCC("ALFC"), // TES5
        SUB_ALFD = fourCC("ALFD"), // TES5
        SUB_ALFE = fourCC("ALFE"), // TES5
        SUB_ALFI = fourCC("ALFI"), // TES5
        SUB_ALFL = fourCC("ALFL"), // TES5
        SUB_ALFR = fourCC("ALFR"), // TES5
        SUB_ALFV = fourCC("ALFV"), // FO4
        SUB_ALID = fourCC("ALID"), // TES5
        SUB_ALLA = fourCC("ALLA"), // FO4
        SUB_ALLS = fourCC("ALLS"), // TES5
        SUB_ALMI = fourCC("ALMI"), // FO4
        SUB_ALNA = fourCC("ALNA"), // TES5
        SUB_ALNT = fourCC("ALNT"), // TES5
        SUB_ALPC = fourCC("ALPC"), // TES5
        SUB_ALRT = fourCC("ALRT"), // TES5
        SUB_ALSP = fourCC("ALSP"), // TES5
        SUB_ALST = fourCC("ALST"), // TES5
        SUB_ALUA = fourCC("ALUA"), // TES5
        SUB_ANAM = fourCC("ANAM"),
        SUB_AOR2 = fourCC("AOR2"), // FO4
        SUB_APPR = fourCC("APPR"), // FO4
        SUB_ATKD = fourCC("ATKD"),
        SUB_ATKE = fourCC("ATKE"),
        SUB_ATKR = fourCC("ATKR"),
        SUB_ATKS = fourCC("ATKS"), // FO4
        SUB_ATKT = fourCC("ATKT"), // FO4
        SUB_ATKW = fourCC("ATKW"), // FO4
        SUB_ATTN = fourCC("ATTN"), // FO4
        SUB_ATTR = fourCC("ATTR"),
        SUB_ATTX = fourCC("ATTX"), // FO4
        SUB_ATXT = fourCC("ATXT"),
        SUB_AVFL = fourCC("AVFL"), // FO4
        SUB_AVSK = fourCC("AVSK"), // TES5
        SUB_BAMT = fourCC("BAMT"),
        SUB_BCLF = fourCC("BCLF"), // FO4
        SUB_BIDS = fourCC("BIDS"),
        SUB_BIPL = fourCC("BIPL"), // FO3
        SUB_BMCT = fourCC("BMCT"),
        SUB_BMDT = fourCC("BMDT"),
        SUB_BMMP = fourCC("BMMP"), // FO4
        SUB_BNAM = fourCC("BNAM"),
        SUB_BOD2 = fourCC("BOD2"),
        SUB_BODT = fourCC("BODT"),
        SUB_BPND = fourCC("BPND"),
        SUB_BPNI = fourCC("BPNI"),
        SUB_BPNN = fourCC("BPNN"),
        SUB_BPNT = fourCC("BPNT"),
        SUB_BPTN = fourCC("BPTN"),
        SUB_BRUS = fourCC("BRUS"), // FONV
        SUB_BSIZ = fourCC("BSIZ"), // FO4
        SUB_BSMB = fourCC("BSMB"), // FO4
        SUB_BSMP = fourCC("BSMP"), // FO4
        SUB_BSMS = fourCC("BSMS"), // FO4
        SUB_BTXT = fourCC("BTXT"),
        SUB_CDIX = fourCC("CDIX"), // FO4
        SUB_CIS1 = fourCC("CIS1"), // TES5
        SUB_CIS2 = fourCC("CIS2"), // TES5
        SUB_CITC = fourCC("CITC"), // TES5
        SUB_CLSZ = fourCC("CLSZ"), // FO4
        SUB_CNAM = fourCC("CNAM"),
        SUB_CNTO = fourCC("CNTO"),
        SUB_COCT = fourCC("COCT"),
        SUB_COED = fourCC("COED"),
        SUB_CRDT = fourCC("CRDT"),
        SUB_CRGR = fourCC("CRGR"), // TES5
        SUB_CRIF = fourCC("CRIF"),
        SUB_CRIS = fourCC("CRIS"), // FO4
        SUB_CRVA = fourCC("CRVA"), // TES5
        SUB_CS2D = fourCC("CS2D"), // FO4
        SUB_CS2E = fourCC("CS2E"), // FO4
        SUB_CS2F = fourCC("CS2F"), // FO4
        SUB_CS2H = fourCC("CS2H"), // FO4
        SUB_CS2K = fourCC("CS2K"), // FO4
        SUB_CSCR = fourCC("CSCR"),
        SUB_CSCV = fourCC("CSCV"), // FO4
        SUB_CSDC = fourCC("CSDC"),
        SUB_CSDI = fourCC("CSDI"),
        SUB_CSDT = fourCC("CSDT"),
        SUB_CSFL = fourCC("CSFL"), // TES5
        SUB_CSGD = fourCC("CSGD"), // TES5
        SUB_CSLR = fourCC("CSLR"), // TES5
        SUB_CSMD = fourCC("CSMD"), // TES5
        SUB_CSME = fourCC("CSME"), // TES5
        SUB_CSRA = fourCC("CSRA"), // FO4
        SUB_CTDA = fourCC("CTDA"),
        SUB_CTDT = fourCC("CTDT"),
        SUB_CUSD = fourCC("CUSD"), // FO4
        SUB_CVPA = fourCC("CVPA"), // FO4
        SUB_DALC = fourCC("DALC"), // FO3
        SUB_DAMA = fourCC("DAMA"), // FO4
        SUB_DAMC = fourCC("DAMC"), // FO4
        SUB_DAT2 = fourCC("DAT2"), // FONV
        SUB_DATA = fourCC("DATA"),
        SUB_DELE = fourCC("DELE"),
        SUB_DEMO = fourCC("DEMO"), // TES5
        SUB_DESC = fourCC("DESC"),
        SUB_DEST = fourCC("DEST"),
        SUB_DEVA = fourCC("DEVA"), // TES5
        SUB_DFTF = fourCC("DFTF"),
        SUB_DFTM = fourCC("DFTM"),
        SUB_DMAX = fourCC("DMAX"), // TES5
        SUB_DMDC = fourCC("DMDC"), // FO4
        SUB_DMDL = fourCC("DMDL"),
        SUB_DMDS = fourCC("DMDS"),
        SUB_DMDT = fourCC("DMDT"),
        SUB_DMIN = fourCC("DMIN"), // TES5
        SUB_DNAM = fourCC("DNAM"),
        SUB_DODT = fourCC("DODT"),
        SUB_DOFT = fourCC("DOFT"),
        SUB_DPLT = fourCC("DPLT"),
        SUB_DSTA = fourCC("DSTA"), // FO4
        SUB_DSTD = fourCC("DSTD"),
        SUB_DSTF = fourCC("DSTF"),
        SUB_DTGT = fourCC("DTGT"), // FO4
        SUB_DTID = fourCC("DTID"), // FO4
        SUB_EAMT = fourCC("EAMT"),
        SUB_ECOR = fourCC("ECOR"),
        SUB_EDID = fourCC("EDID"),
        SUB_EFID = fourCC("EFID"),
        SUB_EFIT = fourCC("EFIT"),
        SUB_EFSD = fourCC("EFSD"), // FONV DeadMoney
        SUB_EITM = fourCC("EITM"),
        SUB_ENAM = fourCC("ENAM"),
        SUB_ENIT = fourCC("ENIT"),
        SUB_EPF2 = fourCC("EPF2"),
        SUB_EPF3 = fourCC("EPF3"),
        SUB_EPFB = fourCC("EPFB"), // FO4
        SUB_EPFD = fourCC("EPFD"),
        SUB_EPFT = fourCC("EPFT"),
        SUB_ESCE = fourCC("ESCE"),
        SUB_ETYP = fourCC("ETYP"),
        SUB_FCHT = fourCC("FCHT"), // TES5
        SUB_FCPL = fourCC("FCPL"), // FO4
        SUB_FFFF = fourCC("FFFF"),
        SUB_FGGA = fourCC("FGGA"),
        SUB_FGGS = fourCC("FGGS"),
        SUB_FGTS = fourCC("FGTS"),
        SUB_FIMD = fourCC("FIMD"), // FO4
        SUB_FLMV = fourCC("FLMV"),
        SUB_FLTR = fourCC("FLTR"), // TES5
        SUB_FLTV = fourCC("FLTV"),
        SUB_FMIN = fourCC("FMIN"), // FO4
        SUB_FMRI = fourCC("FMRI"), // FO4
        SUB_FMRN = fourCC("FMRN"), // FO4
        SUB_FMRS = fourCC("FMRS"), // FO4
        SUB_FNAM = fourCC("FNAM"),
        SUB_FNMK = fourCC("FNMK"),
        SUB_FNPR = fourCC("FNPR"),
        SUB_FPRT = fourCC("FPRT"), // TES5
        SUB_FTSF = fourCC("FTSF"),
        SUB_FTSM = fourCC("FTSM"),
        SUB_FTST = fourCC("FTST"),
        SUB_FTYP = fourCC("FTYP"), // FO4
        SUB_FULL = fourCC("FULL"),
        SUB_FVPA = fourCC("FVPA"), // FO4
        SUB_GNAM = fourCC("GNAM"),
        SUB_GREE = fourCC("GREE"), // FO4
        SUB_GWOR = fourCC("GWOR"), // TES5
        SUB_HCLF = fourCC("HCLF"),
        SUB_HCLR = fourCC("HCLR"),
        SUB_HEAD = fourCC("HEAD"),
        SUB_HEDR = fourCC("HEDR"),
        SUB_HLTX = fourCC("HLTX"), // FO4
        SUB_HNAM = fourCC("HNAM"),
        SUB_HTID = fourCC("HTID"), // TES5
        SUB_ICO2 = fourCC("ICO2"),
        SUB_ICON = fourCC("ICON"),
        SUB_IDLA = fourCC("IDLA"),
        SUB_IDLB = fourCC("IDLB"), // FO3
        SUB_IDLC = fourCC("IDLC"),
        SUB_IDLF = fourCC("IDLF"),
        SUB_IDLT = fourCC("IDLT"),
        SUB_IMPF = fourCC("IMPF"), // FO3 Anchorage
        SUB_IMPS = fourCC("IMPS"), // FO3 Anchorage
        SUB_IMSP = fourCC("IMSP"), // TES5
        SUB_INAM = fourCC("INAM"),
        SUB_INCC = fourCC("INCC"),
        SUB_INDX = fourCC("INDX"),
        SUB_INFC = fourCC("INFC"), // FONV
        SUB_INFX = fourCC("INFX"), // FONV
        SUB_INRD = fourCC("INRD"), // FO4
        SUB_INTT = fourCC("INTT"), // FO4
        SUB_INTV = fourCC("INTV"),
        SUB_IOVR = fourCC("IOVR"), // FO4
        SUB_ISIZ = fourCC("ISIZ"), // FO4
        SUB_ITID = fourCC("ITID"), // FO4
        SUB_ITMC = fourCC("ITMC"), // FO4
        SUB_ITME = fourCC("ITME"), // FO4
        SUB_ITMS = fourCC("ITMS"), // FO4
        SUB_ITXT = fourCC("ITXT"),
        SUB_JAIL = fourCC("JAIL"), // TES5
        SUB_JNAM = fourCC("JNAM"), // FONV
        SUB_JOUT = fourCC("JOUT"), // TES5
        SUB_KFFZ = fourCC("KFFZ"),
        SUB_KNAM = fourCC("KNAM"),
        SUB_KSIZ = fourCC("KSIZ"),
        SUB_KWDA = fourCC("KWDA"),
        SUB_LCEC = fourCC("LCEC"), // TES5
        SUB_LCEP = fourCC("LCEP"), // TES5
        SUB_LCID = fourCC("LCID"), // TES5
        SUB_LCPR = fourCC("LCPR"), // TES5
        SUB_LCSR = fourCC("LCSR"), // TES5
        SUB_LCUN = fourCC("LCUN"), // TES5
        SUB_LFSD = fourCC("LFSD"), // FO4
        SUB_LFSP = fourCC("LFSP"), // FO4
        SUB_LLCT = fourCC("LLCT"),
        SUB_LLKC = fourCC("LLKC"), // FO4
        SUB_LNAM = fourCC("LNAM"),
        SUB_LTMP = fourCC("LTMP"),
        SUB_LTPC = fourCC("LTPC"), // FO4
        SUB_LTPT = fourCC("LTPT"), // FO4
        SUB_LVLD = fourCC("LVLD"),
        SUB_LVLF = fourCC("LVLF"),
        SUB_LVLG = fourCC("LVLG"), // FO3
        SUB_LVLM = fourCC("LVLM"), // FO4
        SUB_LVLO = fourCC("LVLO"),
        SUB_LVSG = fourCC("LVSG"), // FO4
        SUB_MASE = fourCC("MASE"), // FO4
        SUB_MAST = fourCC("MAST"),
        SUB_MCHT = fourCC("MCHT"), // TES5
        SUB_MDOB = fourCC("MDOB"),
        SUB_MHDT = fourCC("MHDT"),
        SUB_MIC2 = fourCC("MIC2"),
        SUB_MICO = fourCC("MICO"),
        SUB_MLSI = fourCC("MLSI"), // FO4
        SUB_MMRK = fourCC("MMRK"), // FONV
        SUB_MNAM = fourCC("MNAM"),
        SUB_MO2B = fourCC("MO2B"),
        SUB_MO2C = fourCC("MO2C"), // FO4
        SUB_MO2F = fourCC("MO2F"), // FO4
        SUB_MO2S = fourCC("MO2S"),
        SUB_MO2T = fourCC("MO2T"),
        SUB_MO3B = fourCC("MO3B"),
        SUB_MO3C = fourCC("MO3C"), // FO4
        SUB_MO3F = fourCC("MO3F"), // FO4
        SUB_MO3S = fourCC("MO3S"), // FO3
        SUB_MO3T = fourCC("MO3T"),
        SUB_MO4B = fourCC("MO4B"),
        SUB_MO4C = fourCC("MO4C"), // FO4
        SUB_MO4F = fourCC("MO4F"), // FO4
        SUB_MO4S = fourCC("MO4S"),
        SUB_MO4T = fourCC("MO4T"),
        SUB_MO5C = fourCC("MO5C"), // FO4
        SUB_MO5F = fourCC("MO5F"), // FO4
        SUB_MO5S = fourCC("MO5S"), // TES5
        SUB_MO5T = fourCC("MO5T"),
        SUB_MOD2 = fourCC("MOD2"),
        SUB_MOD3 = fourCC("MOD3"),
        SUB_MOD4 = fourCC("MOD4"),
        SUB_MOD5 = fourCC("MOD5"),
        SUB_MODB = fourCC("MODB"),
        SUB_MODC = fourCC("MODC"), // FO4
        SUB_MODD = fourCC("MODD"), // FO3
        SUB_MODF = fourCC("MODF"), // FO4
        SUB_MODL = fourCC("MODL"),
        SUB_MODQ = fourCC("MODQ"), // FO4
        SUB_MODS = fourCC("MODS"),
        SUB_MODT = fourCC("MODT"),
        SUB_MOSD = fourCC("MOSD"), // FO3
        SUB_MPAI = fourCC("MPAI"),
        SUB_MPAV = fourCC("MPAV"),
        SUB_MPCD = fourCC("MPCD"), // FO4
        SUB_MPGN = fourCC("MPGN"), // FO4
        SUB_MPGS = fourCC("MPGS"), // FO4
        SUB_MPPC = fourCC("MPPC"), // FO4
        SUB_MPPF = fourCC("MPPF"), // FO4
        SUB_MPPI = fourCC("MPPI"), // FO4
        SUB_MPPK = fourCC("MPPK"), // FO4
        SUB_MPPM = fourCC("MPPM"), // FO4
        SUB_MPPN = fourCC("MPPN"), // FO4
        SUB_MPPT = fourCC("MPPT"), // FO4
        SUB_MPRT = fourCC("MPRT"), // TES5
        SUB_MRSV = fourCC("MRSV"), // FO4
        SUB_MSDK = fourCC("MSDK"), // FO4
        SUB_MSDV = fourCC("MSDV"), // FO4
        SUB_MSID = fourCC("MSID"), // FO4
        SUB_MSM0 = fourCC("MSM0"), // FO4
        SUB_MSM1 = fourCC("MSM1"), // FO4
        SUB_MTNM = fourCC("MTNM"),
        SUB_MTYP = fourCC("MTYP"),
        SUB_MWD1 = fourCC("MWD1"), // FONV
        SUB_MWD2 = fourCC("MWD2"), // FONV
        SUB_MWD3 = fourCC("MWD3"), // FONV
        SUB_MWD4 = fourCC("MWD4"), // FONV
        SUB_MWD5 = fourCC("MWD5"), // FONV
        SUB_MWD6 = fourCC("MWD6"), // FONV
        SUB_MWD7 = fourCC("MWD7"), // FONV
        SUB_MWGT = fourCC("MWGT"), // FO4
        SUB_NAM0 = fourCC("NAM0"),
        SUB_NAM1 = fourCC("NAM1"),
        SUB_NAM2 = fourCC("NAM2"),
        SUB_NAM3 = fourCC("NAM3"),
        SUB_NAM4 = fourCC("NAM4"),
        SUB_NAM5 = fourCC("NAM5"),
        SUB_NAM6 = fourCC("NAM6"),
        SUB_NAM7 = fourCC("NAM7"),
        SUB_NAM8 = fourCC("NAM8"),
        SUB_NAM9 = fourCC("NAM9"),
        SUB_NAMA = fourCC("NAMA"),
        SUB_NAME = fourCC("NAME"),
        SUB_NETO = fourCC("NETO"), // FO4
        SUB_NEXT = fourCC("NEXT"), // FO3
        SUB_NIFT = fourCC("NIFT"),
        SUB_NIFZ = fourCC("NIFZ"),
        SUB_NNAM = fourCC("NNAM"),
        SUB_NNGS = fourCC("NNGS"), // FO4
        SUB_NNGT = fourCC("NNGT"), // FO4
        SUB_NNUS = fourCC("NNUS"), // FO4
        SUB_NNUT = fourCC("NNUT"), // FO4
        SUB_NONE = fourCC("NONE"), // FO4
        SUB_NPOS = fourCC("NPOS"), // FO4
        SUB_NPOT = fourCC("NPOT"), // FO4
        SUB_NQUS = fourCC("NQUS"), // FO4
        SUB_NQUT = fourCC("NQUT"), // FO4
        SUB_NTOP = fourCC("NTOP"), // FO4
        SUB_NTRM = fourCC("NTRM"), // FO4
        SUB_NULL = fourCC("NULL"),
        SUB_NVCA = fourCC("NVCA"), // FO3
        SUB_NVCI = fourCC("NVCI"), // FO3
        SUB_NVDP = fourCC("NVDP"), // FO3
        SUB_NVER = fourCC("NVER"),
        SUB_NVEX = fourCC("NVEX"), // FO3
        SUB_NVGD = fourCC("NVGD"), // FO3
        SUB_NVMI = fourCC("NVMI"),
        SUB_NVNM = fourCC("NVNM"),
        SUB_NVPP = fourCC("NVPP"),
        SUB_NVSI = fourCC("NVSI"),
        SUB_NVTR = fourCC("NVTR"), // FO3
        SUB_NVVX = fourCC("NVVX"), // FO3
        SUB_OBND = fourCC("OBND"),
        SUB_OBTE = fourCC("OBTE"), // FO4
        SUB_OBTF = fourCC("OBTF"), // FO4
        SUB_OBTS = fourCC("OBTS"), // FO4
        SUB_OCOR = fourCC("OCOR"), // TES5
        SUB_OFST = fourCC("OFST"), // TES4 only?
        SUB_ONAM = fourCC("ONAM"),
        SUB_PCMB = fourCC("PCMB"), // FO4
        SUB_PDTO = fourCC("PDTO"),
        SUB_PFIG = fourCC("PFIG"),
        SUB_PFO2 = fourCC("PFO2"), // TES5
        SUB_PFOR = fourCC("PFOR"), // TES5
        SUB_PFPC = fourCC("PFPC"),
        SUB_PFRN = fourCC("PFRN"), // FO4
        SUB_PGAG = fourCC("PGAG"),
        SUB_PGRI = fourCC("PGRI"),
        SUB_PGRL = fourCC("PGRL"),
        SUB_PGRP = fourCC("PGRP"),
        SUB_PGRR = fourCC("PGRR"),
        SUB_PHTN = fourCC("PHTN"),
        SUB_PHWT = fourCC("PHWT"),
        SUB_PKAM = fourCC("PKAM"), // FO3
        SUB_PKC2 = fourCC("PKC2"), // TES5
        SUB_PKCU = fourCC("PKCU"), // TES5
        SUB_PKD2 = fourCC("PKD2"), // FO3
        SUB_PKDD = fourCC("PKDD"), // FO3
        SUB_PKDT = fourCC("PKDT"),
        SUB_PKE2 = fourCC("PKE2"), // FO3
        SUB_PKED = fourCC("PKED"), // FO3
        SUB_PKFD = fourCC("PKFD"), // FO3
        SUB_PKID = fourCC("PKID"),
        SUB_PKPT = fourCC("PKPT"), // FO3
        SUB_PKW3 = fourCC("PKW3"), // FO3
        SUB_PLCN = fourCC("PLCN"), // TES5
        SUB_PLD2 = fourCC("PLD2"), // FO3
        SUB_PLDT = fourCC("PLDT"),
        SUB_PLVD = fourCC("PLVD"), // TES5
        SUB_PNAM = fourCC("PNAM"),
        SUB_POBA = fourCC("POBA"), // FO3
        SUB_POCA = fourCC("POCA"), // FO3
        SUB_POEA = fourCC("POEA"), // FO3
        SUB_PRCB = fourCC("PRCB"), // TES5
        SUB_PRKC = fourCC("PRKC"),
        SUB_PRKE = fourCC("PRKE"),
        SUB_PRKF = fourCC("PRKF"),
        SUB_PRKR = fourCC("PRKR"),
        SUB_PRKZ = fourCC("PRKZ"),
        SUB_PRPS = fourCC("PRPS"), // FO4
        SUB_PSDT = fourCC("PSDT"),
        SUB_PTD2 = fourCC("PTD2"), // FO3
        SUB_PTDA = fourCC("PTDA"), // TES5
        SUB_PTDT = fourCC("PTDT"),
        SUB_PTOP = fourCC("PTOP"), // FO4
        SUB_PTRN = fourCC("PTRN"), // FO4
        SUB_PUID = fourCC("PUID"), // FO3
        SUB_QNAM = fourCC("QNAM"),
        SUB_QOBJ = fourCC("QOBJ"), // FO3
        SUB_QSDT = fourCC("QSDT"),
        SUB_QSTA = fourCC("QSTA"),
        SUB_QSTI = fourCC("QSTI"),
        SUB_QSTR = fourCC("QSTR"),
        SUB_QTGL = fourCC("QTGL"), // TES5
        SUB_QTOP = fourCC("QTOP"), // FO4
        SUB_QUAL = fourCC("QUAL"),
        SUB_RADR = fourCC("RADR"), // FO4
        SUB_RAGA = fourCC("RAGA"),
        SUB_RBPC = fourCC("RBPC"), // FO4
        SUB_RCEC = fourCC("RCEC"), // TES5
        SUB_RCIL = fourCC("RCIL"), // FONV
        SUB_RCLR = fourCC("RCLR"),
        SUB_RCPR = fourCC("RCPR"), // TES5 Dawnguard
        SUB_RCSR = fourCC("RCSR"), // TES5
        SUB_RCUN = fourCC("RCUN"), // TES5
        SUB_RDAT = fourCC("RDAT"),
        SUB_RDGS = fourCC("RDGS"),
        SUB_RDID = fourCC("RDID"), // FONV
        SUB_RDMD = fourCC("RDMD"), // TES4 only?
        SUB_RDMO = fourCC("RDMO"),
        SUB_RDMP = fourCC("RDMP"),
        SUB_RDOT = fourCC("RDOT"),
        SUB_RDSA = fourCC("RDSA"),
        SUB_RDSB = fourCC("RDSB"), // FONV
        SUB_RDSD = fourCC("RDSD"), // TES4 only?
        SUB_RDSI = fourCC("RDSI"), // FONV
        SUB_RDWT = fourCC("RDWT"),
        SUB_REPL = fourCC("REPL"), // FO3
        SUB_REPT = fourCC("REPT"), // FO4
        SUB_RLDM = fourCC("RLDM"), // FO4
        SUB_RNAM = fourCC("RNAM"),
        SUB_RNMV = fourCC("RNMV"),
        SUB_RPLD = fourCC("RPLD"),
        SUB_RPLI = fourCC("RPLI"),
        SUB_RPRF = fourCC("RPRF"),
        SUB_RPRM = fourCC("RPRM"),
        SUB_RVIS = fourCC("RVIS"), // FO4
        SUB_SADD = fourCC("SADD"), // FO4
        SUB_SAKD = fourCC("SAKD"), // FO4
        SUB_SAPT = fourCC("SAPT"), // FO4
        SUB_SCDA = fourCC("SCDA"),
        SUB_SCHD = fourCC("SCHD"),
        SUB_SCHR = fourCC("SCHR"),
        SUB_SCIT = fourCC("SCIT"),
        SUB_SCQS = fourCC("SCQS"), // FO4
        SUB_SCRI = fourCC("SCRI"),
        SUB_SCRN = fourCC("SCRN"),
        SUB_SCRO = fourCC("SCRO"),
        SUB_SCRV = fourCC("SCRV"), // FONV
        SUB_SCTX = fourCC("SCTX"),
        SUB_SCVR = fourCC("SCVR"), // FONV
        SUB_SDSC = fourCC("SDSC"),
        SUB_SGNM = fourCC("SGNM"), // FO4
        SUB_SHRT = fourCC("SHRT"),
        SUB_SLCP = fourCC("SLCP"),
        SUB_SLSD = fourCC("SLSD"), // FONV
        SUB_SNAM = fourCC("SNAM"),
        SUB_SNDD = fourCC("SNDD"),
        SUB_SNDX = fourCC("SNDX"),
        SUB_SNMV = fourCC("SNMV"),
        SUB_SOFT = fourCC("SOFT"),
        SUB_SOUL = fourCC("SOUL"),
        SUB_SPCT = fourCC("SPCT"),
        SUB_SPED = fourCC("SPED"),
        SUB_SPIT = fourCC("SPIT"),
        SUB_SPLO = fourCC("SPLO"),
        SUB_SPMV = fourCC("SPMV"), // TES5
        SUB_SPOR = fourCC("SPOR"),
        SUB_SRAC = fourCC("SRAC"), // FO4
        SUB_SRAF = fourCC("SRAF"), // FO4
        SUB_SSPN = fourCC("SSPN"), // FO4
        SUB_STCP = fourCC("STCP"), // FO4
        SUB_STKD = fourCC("STKD"), // FO4
        SUB_STOL = fourCC("STOL"), // TES5
        SUB_STOP = fourCC("STOP"), // FO4
        SUB_STSC = fourCC("STSC"), // FO4
        SUB_SWMV = fourCC("SWMV"),
        SUB_TCFU = fourCC("TCFU"), // FONV
        SUB_TCLF = fourCC("TCLF"),
        SUB_TCLT = fourCC("TCLT"),
        SUB_TDUM = fourCC("TDUM"), // FONV
        SUB_TEND = fourCC("TEND"), // FO4
        SUB_TETI = fourCC("TETI"), // FO4
        SUB_TIAS = fourCC("TIAS"),
        SUB_TIFC = fourCC("TIFC"), // TES5
        SUB_TINC = fourCC("TINC"),
        SUB_TIND = fourCC("TIND"),
        SUB_TINI = fourCC("TINI"),
        SUB_TINL = fourCC("TINL"),
        SUB_TINP = fourCC("TINP"),
        SUB_TINT = fourCC("TINT"),
        SUB_TINV = fourCC("TINV"),
        SUB_TIQS = fourCC("TIQS"), // FO4
        SUB_TIRS = fourCC("TIRS"),
        SUB_TNAM = fourCC("TNAM"),
        SUB_TPIC = fourCC("TPIC"),
        SUB_TPLT = fourCC("TPLT"),
        SUB_TPTA = fourCC("TPTA"), // FO4
        SUB_TRDA = fourCC("TRDA"), // FO4
        SUB_TRDT = fourCC("TRDT"),
        SUB_TSCE = fourCC("TSCE"), // FO4
        SUB_TTEB = fourCC("TTEB"), // FO4
        SUB_TTEC = fourCC("TTEC"), // FO4
        SUB_TTED = fourCC("TTED"), // FO4
        SUB_TTEF = fourCC("TTEF"), // FO4
        SUB_TTET = fourCC("TTET"), // FO4
        SUB_TTGE = fourCC("TTGE"), // FO4
        SUB_TTGP = fourCC("TTGP"), // FO4
        SUB_TVDT = fourCC("TVDT"),
        SUB_TWAT = fourCC("TWAT"), // TES5
        SUB_TX00 = fourCC("TX00"),
        SUB_TX01 = fourCC("TX01"),
        SUB_TX02 = fourCC("TX02"),
        SUB_TX03 = fourCC("TX03"),
        SUB_TX04 = fourCC("TX04"),
        SUB_TX05 = fourCC("TX05"),
        SUB_TX06 = fourCC("TX06"),
        SUB_TX07 = fourCC("TX07"),
        SUB_UNAM = fourCC("UNAM"),
        SUB_UNES = fourCC("UNES"),
        SUB_UNWP = fourCC("UNWP"), // FO4
        SUB_VANM = fourCC("VANM"), // FONV
        SUB_VATS = fourCC("VATS"), // FONV
        SUB_VCLR = fourCC("VCLR"),
        SUB_VENC = fourCC("VENC"), // TES5
        SUB_VEND = fourCC("VEND"), // TES5
        SUB_VENV = fourCC("VENV"), // TES5
        SUB_VHGT = fourCC("VHGT"),
        SUB_VISI = fourCC("VISI"), // FO4
        SUB_VMAD = fourCC("VMAD"),
        SUB_VNAM = fourCC("VNAM"),
        SUB_VNML = fourCC("VNML"),
        SUB_VTCK = fourCC("VTCK"),
        SUB_VTEX = fourCC("VTEX"),
        SUB_VTXT = fourCC("VTXT"),
        SUB_WAIT = fourCC("WAIT"), // TES5
        SUB_WAMD = fourCC("WAMD"), // FO4
        SUB_WBDT = fourCC("WBDT"),
        SUB_WCTR = fourCC("WCTR"),
        SUB_WGDR = fourCC("WGDR"), // FO4
        SUB_WKMV = fourCC("WKMV"),
        SUB_WLEV = fourCC("WLEV"), // FO4
        SUB_WLST = fourCC("WLST"),
        SUB_WMAP = fourCC("WMAP"), // FO4
        SUB_WMI1 = fourCC("WMI1"), // FONV
        SUB_WMI2 = fourCC("WMI2"), // FONV
        SUB_WMI3 = fourCC("WMI3"), // FONV
        SUB_WMS1 = fourCC("WMS1"), // FONV
        SUB_WMS2 = fourCC("WMS2"), // FONV
        SUB_WNAM = fourCC("WNAM"),
        SUB_WNM1 = fourCC("WNM1"), // FONV
        SUB_WNM2 = fourCC("WNM2"), // FONV
        SUB_WNM3 = fourCC("WNM3"), // FONV
        SUB_WNM4 = fourCC("WNM4"), // FONV
        SUB_WNM5 = fourCC("WNM5"), // FONV
        SUB_WNM6 = fourCC("WNM6"), // FONV
        SUB_WNM7 = fourCC("WNM7"), // FONV
        SUB_WZMD = fourCC("WZMD"), // FO4
        SUB_XACT = fourCC("XACT"),
        SUB_XALP = fourCC("XALP"),
        SUB_XAMC = fourCC("XAMC"), // FO3
        SUB_XAMT = fourCC("XAMT"), // FO3
        SUB_XAPD = fourCC("XAPD"),
        SUB_XAPR = fourCC("XAPR"),
        SUB_XASP = fourCC("XASP"), // FO4
        SUB_XATO = fourCC("XATO"), // FONV
        SUB_XATP = fourCC("XATP"), // FO4
        SUB_XATR = fourCC("XATR"),
        SUB_XBSD = fourCC("XBSD"), // FO4
        SUB_XCAS = fourCC("XCAS"),
        SUB_XCCM = fourCC("XCCM"),
        SUB_XCCP = fourCC("XCCP"),
        SUB_XCET = fourCC("XCET"), // FO3
        SUB_XCGD = fourCC("XCGD"),
        SUB_XCHG = fourCC("XCHG"), // thievery.exp
        SUB_XCIM = fourCC("XCIM"),
        SUB_XCLC = fourCC("XCLC"),
        SUB_XCLL = fourCC("XCLL"),
        SUB_XCLP = fourCC("XCLP"), // FO3
        SUB_XCLR = fourCC("XCLR"),
        SUB_XCLW = fourCC("XCLW"),
        SUB_XCMO = fourCC("XCMO"),
        SUB_XCMT = fourCC("XCMT"), // TES4 only?
        SUB_XCNT = fourCC("XCNT"),
        SUB_XCRI = fourCC("XCRI"), // FO4
        SUB_XCVL = fourCC("XCVL"),
        SUB_XCVR = fourCC("XCVR"),
        SUB_XCWT = fourCC("XCWT"),
        SUB_XCZA = fourCC("XCZA"),
        SUB_XCZC = fourCC("XCZC"),
        SUB_XCZR = fourCC("XCZR"), // TES5
        SUB_XDCR = fourCC("XDCR"), // FO3
        SUB_XEMI = fourCC("XEMI"),
        SUB_XESP = fourCC("XESP"),
        SUB_XEZN = fourCC("XEZN"),
        SUB_XFVC = fourCC("XFVC"),
        SUB_XGDR = fourCC("XGDR"), // FO4
        SUB_XGLB = fourCC("XGLB"),
        SUB_XHLP = fourCC("XHLP"), // FO3
        SUB_XHLT = fourCC("XHLT"), // Unofficial Oblivion Patch
        SUB_XHOR = fourCC("XHOR"),
        SUB_XHRS = fourCC("XHRS"),
        SUB_XHTW = fourCC("XHTW"),
        SUB_XIBS = fourCC("XIBS"), // FO3
        SUB_XILL = fourCC("XILL"),
        SUB_XILW = fourCC("XILW"), // FO4
        SUB_XIS2 = fourCC("XIS2"),
        SUB_XLCM = fourCC("XLCM"),
        SUB_XLCN = fourCC("XLCN"),
        SUB_XLIB = fourCC("XLIB"),
        SUB_XLIG = fourCC("XLIG"),
        SUB_XLKR = fourCC("XLKR"),
        SUB_XLKT = fourCC("XLKT"), // FO4
        SUB_XLOC = fourCC("XLOC"),
        SUB_XLOD = fourCC("XLOD"),
        SUB_XLRL = fourCC("XLRL"),
        SUB_XLRM = fourCC("XLRM"),
        SUB_XLRT = fourCC("XLRT"),
        SUB_XLTW = fourCC("XLTW"),
        SUB_XLYR = fourCC("XLYR"), // FO4
        SUB_XMBO = fourCC("XMBO"),
        SUB_XMBP = fourCC("XMBP"),
        SUB_XMBR = fourCC("XMBR"),
        SUB_XMRC = fourCC("XMRC"),
        SUB_XMRK = fourCC("XMRK"),
        SUB_XMSP = fourCC("XMSP"), // FO4
        SUB_XNAM = fourCC("XNAM"),
        SUB_XNDP = fourCC("XNDP"),
        SUB_XOCP = fourCC("XOCP"),
        SUB_XORD = fourCC("XORD"), // FO3
        SUB_XOWN = fourCC("XOWN"),
        SUB_XPCI = fourCC("XPCI"),
        SUB_XPDD = fourCC("XPDD"), // FO4
        SUB_XPLK = fourCC("XPLK"), // FO4
        SUB_XPOD = fourCC("XPOD"),
        SUB_XPPA = fourCC("XPPA"),
        SUB_XPRD = fourCC("XPRD"),
        SUB_XPRI = fourCC("XPRI"), // FO4
        SUB_XPRM = fourCC("XPRM"),
        SUB_XPTL = fourCC("XPTL"),
        SUB_XPWR = fourCC("XPWR"),
        SUB_XRAD = fourCC("XRAD"), // FO3
        SUB_XRDO = fourCC("XRDO"), // FO3
        SUB_XRDS = fourCC("XRDS"),
        SUB_XRFG = fourCC("XRFG"), // FO4
        SUB_XRGB = fourCC("XRGB"),
        SUB_XRGD = fourCC("XRGD"),
        SUB_XRMR = fourCC("XRMR"),
        SUB_XRNK = fourCC("XRNK"), // TES4 only?
        SUB_XRTM = fourCC("XRTM"),
        SUB_XSCL = fourCC("XSCL"),
        SUB_XSED = fourCC("XSED"),
        SUB_XSPC = fourCC("XSPC"),
        SUB_XSRD = fourCC("XSRD"), // FONV
        SUB_XSRF = fourCC("XSRF"), // FONV
        SUB_XTEL = fourCC("XTEL"),
        SUB_XTNM = fourCC("XTNM"),
        SUB_XTRG = fourCC("XTRG"),
        SUB_XTRI = fourCC("XTRI"),
        SUB_XWCN = fourCC("XWCN"),
        SUB_XWCS = fourCC("XWCS"),
        SUB_XWCU = fourCC("XWCU"),
        SUB_XWEM = fourCC("XWEM"),
        SUB_XWPG = fourCC("XWPG"), // FO4
        SUB_XWPN = fourCC("XWPN"), // FO4
        SUB_XXXX = fourCC("XXXX"),
        SUB_YNAM = fourCC("YNAM"),
        SUB_ZNAM = fourCC("ZNAM"),
    };

    // Based on http://www.uesp.net/wiki/Tes5Mod:Mod_File_Format#Records
    enum RecordFlag
    {
        Rec_ESM = 0x00000001, // (TES4 record only) Master (ESM) file.
        Rec_Deleted = 0x00000020, // Deleted
        Rec_Constant = 0x00000040, // Constant
        Rec_HiddenLMap = 0x00000040, // (REFR) Hidden From Local Map (Needs Confirmation: Related to shields)
        Rec_Localized = 0x00000080, // (TES4 record only) Is localized. This will make Skyrim load the
                                    //   .STRINGS, .DLSTRINGS, and .ILSTRINGS files associated with the mod.
                                    //   If this flag is not set, lstrings are treated as zstrings.
        Rec_FireOff = 0x00000080, // (PHZD) Turn off fire
        Rec_UpdateAnim = 0x00000100, // Must Update Anims
        Rec_NoAccess = 0x00000100, // (REFR) Inaccessible
        Rec_Hidden = 0x00000200, // (REFR) Hidden from local map
        Rec_StartDead = 0x00000200, // (ACHR) Starts dead /(REFR) MotionBlurCastsShadows
        Rec_Persistent = 0x00000400, // Quest item / Persistent reference
        Rec_DispMenu = 0x00000400, // (LSCR) Displays in Main Menu
        Rec_Disabled = 0x00000800, // Initially disabled
        Rec_Ignored = 0x00001000, // Ignored
        Rec_VisDistant = 0x00008000, // Visible when distant
        Rec_RandAnim = 0x00010000, // (ACTI) Random Animation Start
        Rec_Danger = 0x00020000, // (ACTI) Dangerous / Off limits (Interior cell)
                                 //   Dangerous Can't be set withough Ignore Object Interaction
        Rec_Compressed = 0x00040000, // Data is compressed
        Rec_CanNotWait = 0x00080000, // Can't wait
        Rec_IgnoreObj = 0x00100000, // (ACTI) Ignore Object Interaction
                                    //   Ignore Object Interaction Sets Dangerous Automatically
        Rec_Marker = 0x00800000, // Is Marker
        Rec_Obstacle = 0x02000000, // (ACTI) Obstacle / (REFR) No AI Acquire
        Rec_NavMFilter = 0x04000000, // NavMesh Gen - Filter
        Rec_NavMBBox = 0x08000000, // NavMesh Gen - Bounding Box
        Rec_ExitToTalk = 0x10000000, // (FURN) Must Exit to Talk
        Rec_Refected = 0x10000000, // (REFR) Reflected By Auto Water
        Rec_ChildUse = 0x20000000, // (FURN/IDLM) Child Can Use
        Rec_NoHavok = 0x20000000, // (REFR) Don't Havok Settle
        Rec_NavMGround = 0x40000000, // NavMesh Gen - Ground
        Rec_NoRespawn = 0x40000000, // (REFR) NoRespawn
        Rec_MultiBound = 0x80000000 // (REFR) MultiBound
    };
}

#endif // ESM4_COMMON_H
