#ifndef OPENMW_ESM_PGRD_H
#define OPENMW_ESM_PGRD_H

#include <string>
#include <vector>

#include "components/esm/defs.hpp"
#include "components/esm/refid.hpp"

namespace ESM
{

    class ESMReader;
    class ESMWriter;

    /*
     * Path grid.
     */
    struct Pathgrid
    {
        constexpr static RecNameInts sRecordId = REC_PGRD;

        /// Return a string descriptor for this record type. Currently used for debugging / error logs only.
        static std::string_view getRecordType() { return "Pathgrid"; }

        struct DATAstruct
        {
            int32_t mX, mY; // Grid location, matches cell for exterior cells
            int16_t mGranularity; // Granularity with which the graph was autogenerated
            uint16_t mPoints; // Number of path points.
        }; // 12 bytes

        struct Point // path grid point
        {
            int32_t mX, mY, mZ; // Location of point
            unsigned char mAutogenerated; // autogenerated vs. user coloring flag?
            unsigned char mConnectionNum; // number of connections for this point
            int16_t mUnknown;
            Point& operator=(const float[3]);
            Point(const float[3]);
            Point();
            Point(int x, int y, int z)
                : mX(x)
                , mY(y)
                , mZ(z)
                , mAutogenerated(0)
                , mConnectionNum(0)
                , mUnknown(0)
            {
            }
        }; // 16 bytes

        struct Edge // path grid edge
        {
            size_t mV0, mV1; // index of points connected with this edge
        };

        ESM::RefId mCell; // Cell name
        DATAstruct mData;

        typedef std::vector<Point> PointList;
        PointList mPoints;

        typedef std::vector<Edge> EdgeList;
        EdgeList mEdges;

        void load(ESMReader& esm, bool& isDeleted);
        void save(ESMWriter& esm, bool isDeleted = false) const;

        void blank();
    };
}
#endif
