#!/bin/sh

readlink() {
	path=$1

	if [ -L "$path" ]
	then
		ls -l "$path" | sed 's/^.*-> //'
	else
		return 1
	fi
}

SCRIPT="$0"
COUNT=0
while [ -L "${SCRIPT}" ]
do
	SCRIPT=$(readlink ${SCRIPT})
	COUNT=$(expr ${COUNT} + 1)
	if [ ${COUNT} -gt 100 ]
	then
		echo "Too many symbolic links"
		exit 1
	fi
done
GAMEDIR=$(dirname "${SCRIPT}")

cd $GAMEDIR

export LD_LIBRARY_PATH="./lib"
export QT_PLUGIN_PATH="./plugins"
./openmw-launcher.@ARCH@ "$@"
