#ifndef OPENMW_COMPONENTS_NIFBULLET_BULLETNIFLOADER_HPP
#define OPENMW_COMPONENTS_NIFBULLET_BULLETNIFLOADER_HPP

#include <cassert>
#include <map>
#include <set>
#include <string>

#include <osg/BoundingBox>
#include <osg/Matrixf>
#include <osg/Referenced>
#include <osg/ref_ptr>

#include <BulletCollision/CollisionShapes/btCompoundShape.h>

#include <components/debug/debuglog.hpp>
#include <components/nif/niffile.hpp>
#include <components/resource/bulletshape.hpp>

class btTriangleMesh;
class btCompoundShape;
class btCollisionShape;

namespace Nif
{
    struct Node;
    struct Transformation;
    struct NiTriShape;
    struct NiTriStrips;
    struct NiGeometry;
    struct Parent;
}

namespace NifBullet
{

    /**
     *Load bulletShape from NIF files.
     */
    class BulletNifLoader
    {
    public:
        void warn(const std::string& msg) { Log(Debug::Warning) << "NIFLoader: Warn: " << msg; }

        [[noreturn]] void fail(const std::string& msg)
        {
            Log(Debug::Error) << "NIFLoader: Fail: " << msg;
            abort();
        }

        osg::ref_ptr<Resource::BulletShape> load(Nif::FileView file);

    private:
        bool findBoundingBox(const Nif::Node& node, const std::string& filename);

        void handleNode(const std::string& fileName, const Nif::Node& node, const Nif::Parent* parent, int flags,
            bool isCollisionNode, bool isAnimated, bool autogenerated, bool avoid,
            Resource::VisualCollisionType& visualCollisionType);

        bool hasRootCollisionNode(const Nif::Node& rootNode) const;
        bool collisionShapeIsEmpty(const Nif::Node& rootNode) const;

        void handleNiTriShape(const Nif::NiGeometry& nifNode, const Nif::Parent* parent, const osg::Matrixf& transform,
            bool isAnimated, bool avoid);

        std::unique_ptr<btCompoundShape, Resource::DeleteCollisionShape> mCompoundShape;

        std::unique_ptr<btTriangleMesh> mStaticMesh;

        std::unique_ptr<btTriangleMesh> mAvoidStaticMesh;

        osg::ref_ptr<Resource::BulletShape> mShape;
    };

}

#endif
