/*
  Copyright (C) 2016, 2018, 2020 cc9cii

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
     misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.

  cc9cii cc9c@iinet.net.au

  Much of the information on the data structures are based on the information
  from Tes4Mod:Mod_File_Format and Tes5Mod:File_Formats but also refined by
  trial & error.  See http://en.uesp.net/wiki for details.

*/
#ifndef ESM4_INGR_H
#define ESM4_INGR_H

#include <cstdint>
#include <vector>

#include "effect.hpp"

namespace ESM4
{
    class Reader;
    class Writer;

    struct Ingredient
    {
#pragma pack(push, 1)
        struct Data
        {
            std::uint32_t value;
            float         weight;
        };

        struct ENIT
        {
            std::uint32_t value;
            std::uint32_t flags;
        };
#pragma pack(pop)

        FormId mFormId;       // from the header
        std::uint32_t mFlags; // from the header, see enum type RecordFlag for details

        std::string mEditorId;
        std::string mFullName;
        std::string mModel;
        std::string mIcon; // inventory

        float mBoundRadius;

        std::vector<std::string> mScriptEffect; // FIXME: prob. should be in a struct
        FormId mScriptId;
        ScriptEffect mEffect;
        ENIT   mEnchantment;

        Data mData;

        virtual ~Ingredient();

        virtual void load(ESM4::Reader& reader);
        //virtual void save(ESM4::Writer& writer) const;

        //void blank();
    };
}

#endif // ESM4_INGR_H
