#!/bin/bash
#TODO: Add more error checks

#TODO Add masters commithash after date everywhere
# BUILDARGS etc (-DTGZ_NIGHTLYHASH)?

####################################### "CONSTANTS" #######################################

DATE=$(date +%Y%m%d)
export BUILDDIR="nightly${DATE}"
export BUILDARGS="-DTGZ_NIGHTLY=1 -DTGZ_DATE=${DATE} -DCMAKE_BUILD_TYPE=Release -DCPACK_STRIP_FILES=OFF -DBUILD_ESMTOOL=\"ON\" -DBUILD_BSATOOL=\"ON\" -DBUILD_NIFTEST=\"ON\" -DOPENMW_USE_SYSTEM_RECASTNAVIGATION=\"ON\" -DDEPLOY_QT_TRANSLATIONS=\"ON\""
CHROOTDIR64=./debian_trixie/home/openmwnightly/
COMMITFILE="${PWD}/openmwnightlycommitfile"
PACKAGEDIR=/var/www/html/openmw/nightly
SOURCEPACKAGEDIR=/var/www/html/openmw/source/nightly
OPENMWGITDIR="./openmwnightly"
LOGFILE="${PWD}/nightlylogs/nightly${DATE}.log"
TARGZPACKAGEBRANCH="nightlytargzpackage-debiantrixie"
TMPBRANCH=nightlytmp
CURRENTCOMMITHASH=""

####################################### FUNCTION DECLARATIONS #######################################

#All messages except the real return message must be redirected to /dev/null
#Returns "false" if commit was already built
function checkMaster() {
    echo "========================" >> $LOGFILE
    echo "Checking for new commits" >> $LOGFILE
    echo "========================" >> $LOGFILE
    echo "" >> $LOGFILE
    pushd $OPENMWGITDIR >> $LOGFILE
    git checkout master >> $LOGFILE
    git pull upstream master >> $LOGFILE
    CURRENTCOMMITHASH=$(git log --pretty=format:'%H' -n 1) >> $LOGFILE
    if [ -f "$COMMITFILE" ]
    then
        LASTBUILDCOMMITHASH=$(cat "$COMMITFILE") >> $LOGFILE
    else
        popd >> $LOGFILE
        echo "false"
        return
    fi
    #Check if the current commit is the same as the one we last build
    if [ "$LASTBUILDCOMMITHASH" = "$CURRENTCOMMITHASH" ]
    then
        #We already built this one. Abort.
	echo "Already build aborting" >> $LOGFILE
        popd >> $LOGFILE
        echo "true"
        exit 0
    fi
    popd >> $LOGFILE
    #The commit file will be updated after everything is successfully built
}

# Do not subhsell!
function setCommitHash() {
    pushd $OPENMWGITDIR >> $LOGFILE
    git checkout master >> $LOGFILE
    CURRENTCOMMITHASH=$(git log --pretty=format:'%H' -n 1) >> $LOGFILE
    echo "Current commit hash $CURRENTCOMMITHASH" >> $LOGFILE
    popd >> $LOGFILE
}

function updateLastBuildFile() {
    echo "========================" >> $LOGFILE
    echo "Updating last build file" >> $LOGFILE
    echo "========================" >> $LOGFILE
    echo "" >> $LOGFILE
    pushd "$OPENMWGITDIR" >> $LOGFILE
    git checkout master  >> $LOGFILE
    CURRENTCOMMITHASH=$(git log --pretty=format:'%H' -n 1) >> $LOGFILE
    echo "$CURRENTCOMMITHASH" > $COMMITFILE
    popd >> $LOGFILE
}

#FIXME: Sadly doesn't work like this
#function createNewestLinks() {
#    ln -sf "$PACKAGEDIR"/openmw-${DATE}-Linux-64Bit.tar.gz "$PACKAGEDIR"/newest64
#    ln -sf "$PACKAGEDIR"/openmw-${DATE}-Linux.tar.gz "$PACKAGEDIR"/newest32
#}

function copyLogs() {
    #if [ -f "$CHROOTDIR/$BUILDDIR"/make.log ] && [ -f "$CHROOTDIR64/$BUILDDIR"/make.log ];
    if [ -f "$CHROOTDIR64/$BUILDDIR"/make.log ];
    then
       #cp "$CHROOTDIR/$BUILDDIR"/make.log "$PACKAGEDIR"/logs/${DATE}-make32.log
       cp "$CHROOTDIR64/$BUILDDIR"/make.log "$PACKAGEDIR"/logs/${DATE}-make.log
    fi
}

function makeTmpBranch() {
    echo "========================" >> $LOGFILE
    echo "Creating tmp branch: $TMPBRANCH" >> $LOGFILE
    echo "========================" >> $LOGFILE
    echo "" >> $LOGFILE
    pushd "$OPENMWGITDIR"  >> $LOGFILE
    git checkout $TARGZPACKAGEBRANCH  >> $LOGFILE
    git branch $TMPBRANCH >> $LOGFILE
    git checkout $TMPBRANCH >> $LOGFILE
    #Merge in master
    git merge master >> $LOGFILE
    popd >> $LOGFILE
}

function isBuildSuccessfull() {
    echo "===============================" >> $LOGFILE
    echo "Checking if targzs were created" >> $LOGFILE
    echo "===============================" >> $LOGFILE
    echo "" >> $LOGFILE
    #echo "Testing existance of: $CHROOTDIR/$BUILDDIR/openmw-*${DATE}*.tar.gz" >> $LOGFILE
    echo "Testing existance of: $CHROOTDIR64/$BUILDDIR/openmw-*${DATE}*.tar.gz" >> $LOGFILE
    #if [ -f "$CHROOTDIR/$BUILDDIR"/openmw-*${DATE}*.tar.gz ] && [ -f "$CHROOTDIR64/$BUILDDIR"/openmw-*${DATE}*.tar.gz ]
    if [ -f "$CHROOTDIR64/$BUILDDIR"/openmw-*${DATE}*.tar.gz ]
    then
        echo "true"
    else
        echo "false"
    fi
}

#TODO: Needs error checks
function copyPackages() {
    echo "===============================" >> $LOGFILE
    echo "Copying targz packages" >> $LOGFILE
    echo "===============================" >> $LOGFILE
    echo "" >> $LOGFILE
    #cp "$CHROOTDIR/$BUILDDIR"/openmw-*${DATE}*.tar.gz "$PACKAGEDIR" >> $LOGFILE
    cp "$CHROOTDIR64/$BUILDDIR"/openmw-*${DATE}*.tar.gz "$PACKAGEDIR" >> $LOGFILE
    # not using ftp anymore
    #chown ftp "$PACKAGEDIR"/openmw-*${DATE}*.tar.gz
    chmod +x "$PACKAGEDIR"/openmw-*${DATE}*.tar.gz >> $LOGFILE

    # create source tar
    tar --exclude ".git" -cf /tmp/openmw-${DATE}-${CURRENTCOMMITHASH}-source.tar ${OPENMWGITDIR}/ >> $LOGFILE
    zstd -19 /tmp/openmw-${DATE}-${CURRENTCOMMITHASH}-source.tar >> $LOGFILE
    cp /tmp/openmw-*${DATE}*-source.tar.zst "$SOURCEPACKAGEDIR" >> $LOGFILE
    rm /tmp/openmw-${DATE}-${CURRENTCOMMITHASH}-source.tar >> $LOGFILE
    rm /tmp/openmw-${DATE}-${CURRENTCOMMITHASH}-source.tar.zst >> $LOGFILE
    chmod +x "$SOURCEPACKAGEDIR"/openmw-*${DATE}*-source.tar.zst >> $LOGFILE

    echo "true"
}

####################################### Actual Code #######################################

if [ ! -d "${PWD}/nightlylogs/" ];
then
  echo "No logfile directory (${PWD}/nightlylogs). Aborting"
  exit 0
fi

if [ "$(checkMaster)" = "true" ];
then
  echo "Current commit already built. Aborting" >> $LOGFILE
  exit 0
fi

echo "" >> $LOGFILE
echo "" >> $LOGFILE
echo "Build starting at: $(date '+%Y-%m-%d %H:%M')" >> $LOGFILE
echo "" >> $LOGFILE

setCommitHash

echo "Current commit hash $CURRENTCOMMITHASH" >> $LOGFILE

export BUILDARGS="$BUILDARGS -DTGZ_NIGHTLY_HASH:STRING=$CURRENTCOMMITHASH -DOPENMW_VERSION_COMMITHASH_OVERRIDE=$CURRENTCOMMITHASH"

makeTmpBranch

echo "===============================" >> $LOGFILE
echo "./openmwnightly_makeall.sh" >> $LOGFILE
echo "===============================" >> $LOGFILE
./openmwnightly_makeall.sh >> $LOGFILE
pushd $OPENMWGITDIR
git checkout "$TARGZPACKAGEBRANCH" >> $LOGFILE
git branch -D $TMPBRANCH >> $LOGFILE
popd
if [ $(isBuildSuccessfull) = "true" ] && [ $(copyPackages) = "true" ]
then
    updateLastBuildFile
    #createNewestLinks
fi

echo "Build finished at: $(date '+%Y-%m-%d %H:%M')" >> $LOGFILE
