#!/bin/bash

MAKEFLAGS="-j $(nproc)"

# Deps from repos:

# make sure newest packages are installed
apt update && apt upgrade

apt install automake libasound2-dev libbison-dev bison libboost1.81-all-dev libbzip3-dev cmake libfreetype-dev gettext git mercurial make libtool libarchive-dev libpng-dev libicu-dev libjpeg62-turbo-dev librsvg2-dev libsm-dev libtiff-dev libudev-dev libxml2-dev libxcomposite-dev libxt-dev libxrandr-dev liblz4-dev libegl1-mesa-dev libgbm-dev libsqlite3-dev subversion libxcb-util-dev devscripts libssl-dev libpulse-dev libffi-dev python3 tar libexpat-dev vim which nasm yasm libmp3lame-dev libavcodec-dev libavdevice-dev libavfilter-dev libavformat-dev libavutil-dev libswresample-dev libswscale-dev  wayland-protocols libqt6opengl6-dev libqt6svg6-dev qt6-wayland-dev libluajit-5.1-dev libcollada-dom-dev libunshield-dev libyaml-cpp-dev libopus-dev libvorbis-dev libvpx-dev qt6-tools-dev libusb-1.0-0-dev

# TODO: explain how to add older libexpat to buildenv (required to lower dependency of glibc from version 2.36 to 2.35)

# old qt5
#apt install libqt5opengl5-dev libqt5svg5-dev qt5-wayland-dev qttools5-dev

# librecast-dev  (system package too old: missing cmake files)
# libbullet-dev (has no multithreading...)

# extra sdl2 deps
apt install gir1.2-ibus-1.0 libavc1394-0 libcaca0 libcdio-cdda2 libcdio-paranoia2 libcdio19 libdbus-1-dev libdc1394-25 libdecor-0-0 libdecor-0-dev libdecor-0-plugin-1-cairo libdrm-dev libibus-1.0-5 libibus-1.0-dev libiec61883-0 libjack-jackd2-0 libopenal-data libopenal1 libpciaccess-dev libraw1394-11 libsamplerate0 libsamplerate0-dev libsndio-dev libsndio7.0 libwayland-bin libwayland-dev libxcursor-dev libxi-dev libxinerama-dev libxkbcommon-dev libxss-dev libxss1 libxv-dev libxv1 libxxf86vm-dev


#TODO: check what might be better served by repo package too
#TODO: update to newest versions
# All other dependencies have to be built from source

# Also check /usr/local for pkg-config files
echo "PKG_CONFIG_PATH=\"/usr/local/lib64/pkgconfig:/usr/local/share/pkgconfig/:/usr/local/lib/pkgconfig/:/usr/lib/pkgconfig\";export PKG_CONFIG_PATH" >> ~/.bashrc

source ~/.bashrc

mkdir -p /home/openmwbuild/deps

# replaced with system package
# boost:
#mkdir /home/openmwbuild/deps/boost
#pushd /home/openmwbuild/deps/boost
#curl -L -O https://downloads.sourceforge.net/project/boost/boost/1.73.0/boost_1_73_0.tar.bz2
#sha256sum --quiet -c <(echo "4eb3b8d442b426dc35346235c8733b5ae35ba431690e38c6a8263dce9fcbb402  boost_1_73_0.tar.bz2") || exit
#tar -xf boost_1_73_0.tar.bz2
#cd boost_1_73_0
#./bootstrap.sh
#./b2
#./b2 install
#popd

# cmake:

##mkdir /home/openmwbuild/deps/cmake
##pushd /home/openmwbuild/deps/cmake
##curl -L -O https://cmake.org/files/v3.17/cmake-3.17.3.tar.gz
##tar -xf cmake-3.17.3.tar.gz
##cd cmake-3.17.3 
##./bootstrap
##make install
##popd

# openal: 
mkdir /home/openmwbuild/deps/openal
pushd /home/openmwbuild/deps/openal
curl -L -o openal-soft-1.23.0.tar.gz https://github.com/kcat/openal-soft/archive/refs/tags/1.23.0.tar.gz
sha256sum --quiet -c <(echo "af2abf9cb539c9d66296a83ba63a75eb5868658d0f0b28b27c556f45e70c5231  openal-soft-1.23.0.tar.gz") || exit
tar -xf openal-soft-1.23.0.tar.gz
cd openal-soft-openal-soft-1.23.0
mkdir build
cd build
cmake -DALSOFT_EXAMPLES=OFF -DALSOFT_TESTS=OFF -DALSOFT_UTILS=OFF ..
make $MAKEFLAGS
make install
strip /usr/local/lib/libopenal.so*
popd

# [[FFMPEG (https://trac.ffmpeg.org/wiki/CompilationGuide/Centos)]]
# replaced with system package
# nasm:
#mkdir /home/openmwbuild/deps/nasm
#pushd /home/openmwbuild/deps/nasm
#curl -L -O http://www.nasm.us/pub/nasm/releasebuilds/2.14.02/nasm-2.14.02.tar.bz2
#sha256sum --quiet -c <(echo "34fd26c70a277a9fdd54cb5ecf389badedaf48047b269d1008fbc819b24e80bc  /home/openmwbuild/deps/nasm/nasm-2.14.02.tar.bz2") || exit
#tar -xf nasm-2.14.02.tar.bz2
#cd nasm-2.14.02
#./autogen.sh
#./configure
#make $MAKEFLAGS
#make install
#popd

# yasm:
# replaced with system package
#mkdir /home/openmwbuild/deps/yasm
#pushd /home/openmwbuild/deps/yasm
#curl -L -O http://www.tortall.net/projects/yasm/releases/yasm-1.3.0.tar.gz
#sha256sum --quiet -c <(echo "3dce6601b495f5b3d45b59f7d2492a340ee7e84b5beca17e48f862502bd5603f  yasm-1.3.0.tar.gz") || exit
#tar -xf yasm-1.3.0.tar.gz
#cd yasm-1.3.0
#./configure
#make $MAKEFLAGS
#make install
#popd

# replaced with system package
# lame:
#mkdir /home/openmwbuild/deps/lame
#pushd /home/openmwbuild/deps/lame
#curl -O -L http://downloads.sourceforge.net/project/lame/lame/3.100/lame-3.100.tar.gz
#sha256sum --quiet -c <(echo "ddfe36cab873794038ae2c1210557ad34857a4b6bdc515785d1da9e175b1da1e  lame-3.100.tar.gz") || exit
#tar -xf lame-3.100.tar.gz
#cd lame-3.100
#./configure --disable-static --enable-nasm
#make $MAKEFLAGS
#make install
#popd

# replaced with system package
# libopus:
#mkdir /home/openmwbuild/deps/opus
#pushd /home/openmwbuild/deps/opus
#curl -O -L "https://archive.mozilla.org/pub/opus/opus-1.3.1.tar.gz"
#sha256sum --quiet -c <(echo "65b58e1e25b2a114157014736a3d9dfeaad8d41be1c8179866f144a2fb44ff9d  opus-1.3.1.tar.gz") || exit
#tar -xf opus-1.3.1.tar.gz
#cd opus-1.3.1
#./configure --disable-static
#make $MAKEFLAGS
#make install
#popd

# replaced with system package
# libogg:
#mkdir /home/openmwbuild/deps/ogg
#pushd /home/openmwbuild/deps/ogg
#curl -O -L http://downloads.xiph.org/releases/ogg/libogg-1.3.4.tar.gz
#sha256sum --quiet -c <(echo "fe5670640bd49e828d64d2879c31cb4dde9758681bb664f9bdbf159a01b0c76e  libogg-1.3.4.tar.gz") || exit
#tar -xf libogg-1.3.4.tar.gz
#cd libogg-1.3.4
#./configure --disable-static
#make $MAKEFLAGS
#make install
#popd

# replaced with system package
# libvorbis:
#mkdir /home/openmwbuild/deps/vorbis
#pushd /home/openmwbuild/deps/vorbis
#curl -O -L http://downloads.xiph.org/releases/vorbis/libvorbis-1.3.6.tar.gz
#sha256sum --quiet -c <(echo "6ed40e0241089a42c48604dc00e362beee00036af2d8b3f46338031c9e0351cb  libvorbis-1.3.6.tar.gz") || exit
#tar -xf libvorbis-1.3.6.tar.gz
#cd libvorbis-1.3.6
#./configure --disable-static
#make $MAKEFLAGS
#make install
#popd

# replaced with system package
# libvpx:
#mkdir /home/openmwbuild/deps/vpx
#pushd /home/openmwbuild/deps/vpx
#git clone --depth 1 https://chromium.googlesource.com/webm/libvpx.git
#cd libvpx
#./configure --disable-examples --disable-unit-tests --enable-vp9-highbitdepth --as=yasm --disable-static --enable-shared --enable-pic
#make $MAKEFLAGS
#make install
#popd

# (not replaced by system package as ffmpeg 5+ is too new for osg fork)
# ffmpeg:
mkdir /home/openmwbuild/deps/ffmpeg
pushd /home/openmwbuild/deps/ffmpeg
curl -O -L https://ffmpeg.org/releases/ffmpeg-4.2.3.tar.bz2
sha256sum --quiet -c <(echo "217eb211c33303b37c5521a5abe1f0140854d6810c6a6ee399456cc96356795e  ffmpeg-4.2.3.tar.bz2") || exit
tar -xf ffmpeg-4.2.3.tar.bz2
cd ffmpeg-4.2.3
./configure --enable-gpl --enable-libfreetype --enable-libmp3lame --enable-libopus --enable-libvorbis --enable-libvpx --disable-static --enable-shared
make $MAKEFLAGS
make install
popd

# [[/FFMPEG]]

# still required?
# libtxc_dxtn:
mkdir /home/openmwbuild/deps/txc_dxtn
pushd /home/openmwbuild/deps/txc_dxtn
curl -O -L http://people.freedesktop.org/~cbrill/libtxc_dxtn/libtxc_dxtn-1.0.1.tar.bz2
sha256sum --quiet -c <(echo "45290d12cdca529a3f41e7fc35c4250fc1b6d2fc16b56680f8401f6aa792ae60  libtxc_dxtn-1.0.1.tar.bz2") || exit
tar -xf libtxc_dxtn-1.0.1.tar.bz2
cd libtxc_dxtn-1.0.1
./configure
make $MAKEFLAGS
make install
popd

# replaced with system packages
# wayland
#mkdir /home/openmwbuild/deps/wayland
#pushd /home/openmwbuild/deps/wayland
#curl -L -O https://wayland.freedesktop.org/releases/wayland-1.18.0.tar.xz
#sha256sum --quiet -c <(echo "4675a79f091020817a98fd0484e7208c8762242266967f55a67776936c2e294d  wayland-1.18.0.tar.xz") || exit
#tar -xf wayland-1.18.0.tar.xz
#cd wayland-1.18.0
#EXPAT_CFLAGS="-I/usr/include" EXPAT_LIBS="-L/usr/lib64/ -lexpat" ./configure --disable-static --disable-documentation
#make $MAKEFLAGS
#make install
#popd
#pushd /home/openmwbuild/deps/wayland
#curl -L -O https://wayland.freedesktop.org/releases/wayland-protocols-1.20.tar.xz
#sha256sum --quiet -c <(echo "9782b7a1a863d82d7c92478497d13c758f52e7da4f197aa16443f73de77e4de7  wayland-protocols-1.20.tar.xz") || exit
#tar -xf wayland-protocols-1.20.tar.xz
#cd wayland-protocols-1.20
#./configure
#make install
#popd
#pushd /home/openmwbuild/deps/wayland
## meson and ninja required for building libxkbcommon
#curl -L -O https://github.com/mesonbuild/meson/releases/download/0.54.2/meson-0.54.2.tar.gz
#sha256sum --quiet -c <(echo "a7716eeae8f8dff002e4147642589ab6496ff839e4376a5aed761f83c1fa0455  meson-0.54.2.tar.gz") || exit
#tar -xf meson-0.54.2.tar.gz
#curl -L -O https://github.com/martine/ninja/archive/v1.10.0.zip
#sha256sum --quiet -c <(echo "bb489516d71f6e9c01ae65ab177041e025736bfcb042ac037be9e298abfcb056  v1.10.0.zip") || exit
#unzip v1.10.0.zip
#cd ninja-1.10.0
#python3 configure.py --bootstrap
#popd
#pushd /home/openmwbuild/deps/wayland
#git clone https://github.com/xkbcommon/libxkbcommon
#cd libxkbcommon
#PATH="$PATH:/home/openmwbuild/deps/wayland/ninja-1.10.0"
#python3 /home/openmwbuild/deps/wayland/meson-0.54.2/meson.py build -Denable-docs=false
#ninja -C build
#python3 /home/openmwbuild/deps/wayland/meson-0.54.2/meson.py install -C build
#popd

# sdl2:
mkdir /home/openmwbuild/deps/sdl2
pushd /home/openmwbuild/deps/sdl2
cd sdl2
#curl -O -L "https://libsdl.org/release/SDL2-2.28.5.tar.gz"
#sha512sum -c <(echo "12593eb78fcca877a8dfb78cf21a4e6feba7dc87c964de378ac462b36d8e41ecb587222cb41d5f56dd35b838e1b9867b8ae0cf2f4d2a01afaf23ac8c11edc84d SDL2-2.28.5.tar.gz") || exit
#tar -xf SDL2-2.28.5.tar.gz
#cd SDL2-2.28.5
curl -O -L "https://libsdl.org/release/SDL2-2.30.0.tar.gz"
sha512sum -c <(echo "6eac264db52342d3af338745c5ee7c627982a661194686e06e0ea44d4eb38f88d0b451656edf3169334570ee484132e5a74ab9ed56f9de359728d48f93a0aafa SDL2-2.30.0.tar.gz") || exit
tar -xf SDL2-2.30.0.tar.gz
cd SDL2-2.30.0
#./configure --disable-static
#make $MAKEFLAGS
#make install
cmake -B build -D SDL_STATIC=OFF -D SDL_HIDAPI_LIBUSB=ON
cmake --build build
cmake --install build
popd

# not replaced with system package since it lacks multithreading
# bullet:
mkdir /home/openmwbuild/deps/bullet
pushd /home/openmwbuild/deps/bullet
#curl -L -O https://github.com/bulletphysics/bullet3/archive/2.89.tar.gz
#sha256sum --quiet -c <(echo "621b36e91c0371933f3c2156db22c083383164881d2a6b84636759dc4cbb0bb8  2.89.tar.gz") || exit
#tar -xf 2.89.tar.gz
#cd bullet3-2.89
curl -L -O https://github.com/bulletphysics/bullet3/archive/3.25.tar.gz
sha512sum --quiet -c <(echo "7086e5fcf69635801bb311261173cb8d173b712ca1bd78be03df48fad884674e85512861190e45a1a62d5627aaad65cde08c175c44a3be9afa410d3dfd5358d4  3.25.tar.gz") || exit
tar -xf 3.25.tar.gz
#cd bullet3-3.25
mkdir build
cd build
cmake -DBUILD_SHARED_LIBS="TRUE" -DBUILD_CPU_DEMOS="OFF" -DBUILD_BULLET2_DEMOS="OFF" -DBUILD_EXTRAS="OFF" -DBUILD_UNIT_TESTS="OFF" -DUSE_DOUBLE_PRECISION="ON" -DBULLET2_MULTITHREADING="ON" -DBULLET2_USE_OPEN_MP_MULTITHREADING="ON" -DCMAKE_BUILD_TYPE="Release" -DOpenGL_GL_PREFERENCE="GLVND" ../bullet3-3.25
make $MAKEFLAGS
make install/strip
popd

# mygui:
mkdir /home/openmwbuild/deps/mygui
pushd /home/openmwbuild/deps/mygui
#curl -L -O https://github.com/MyGUI/mygui/archive/MyGUI3.4.2.tar.gz
curl -L -O https://github.com/MyGUI/mygui/archive/MyGUI3.4.3.tar.gz
#sha512sum --quiet -c <(echo "202f3df35f0767778b5a91b71dbd1ad3409d0a1977d5fbe3f0d48db430276c71b84edc5a28dd1fdb8e60245b56f2bda99872a4d860b83585f08406b28fb850fe  MyGUI3.4.2.tar.gz") || exit
sha512sum --quiet -c <(echo "88c69ca2e706af364b72d425f95013eb285501881d8094f8d67e31a54c45ca11b0eb5b62c382af0d4c43f69aa8197648259ac306b72efa7ef3e25eecb9b039cb  MyGUI3.4.3.tar.gz") || exit
#tar -xf MyGUI3.4.2.tar.gz
tar -xf MyGUI3.4.3.tar.gz
#cd mygui-MyGUI3.4.2
#cd mygui-MyGUI3.4.3
#cmake -DCMAKE_INSTALL_PREFIX=/usr/local -DMYGUI_BUILD_SAMPLES=FALSE -DMYGUI_BUILD_DEMOS=FALSE -DMYGUI_BUILD_DOCS=FALSE -DMYGUI_BUILD_TOOLS=FALSE -DMYGUI_INSTALL_SAMPLES=FALSE -DMYGUI_INSTALL_TOOLS=FALSE -DMYGUI_INSTALL_DOCS=FALSE -DMYGUI_INSTALL_MEDIA=FALSE -DFREETYPE_INCLUDE_DIR=/usr/include/freetype2/ -DCMAKE_BUILD_TYPE=Release -DBUILD_SHARED_LIBS=TRUE -DMYGUI_RENDERSYSTEM="4"
cmake -B build -S mygui-MyGUI3.4.3 -D CMAKE_INSTALL_PREFIX=/usr/local -D MYGUI_BUILD_DEMOS=FALSE -D MYGUI_BUILD_DOCS=FALSE -D MYGUI_BUILD_TOOLS=FALSE -D MYGUI_INSTALL_TOOLS=FALSE -D MYGUI_INSTALL_DOCS=FALSE -D CMAKE_BUILD_TYPE=Release -D BUILD_SHARED_LIBS=TRUE -D MYGUI_DONT_USE_OBSOLETE=ON -D MYGUI_RENDERSYSTEM="4" -Wno-dev
# static
#cmake -DCMAKE_INSTALL_PREFIX=/usr -DMYGUI_BUILD_DEMOS=FALSE -DMYGUI_BUILD_DOCS=FALSE -DMYGUI_BUILD_TOOLS=FALSE -DMYGUI_INSTALL_TOOLS=FALSE -DMYGUI_INSTALL_DOCS=FALSE -DCMAKE_BUILD_TYPE=Release -DMYGUI_STATIC=TRUE -DMYGUI_RENDERSYSTEM="4"
cd build
make $MAKEFLAGS
make install/strip
popd

# libpng16
#mkdir /home/openmwbuild/deps/libpng16
#pushd /home/openmwbuild/deps/libpng16
#curl -L -O "https://downloads.sourceforge.net/sourceforge/libpng/libpng-1.6.37.tar.xz"
#sha256sum --quiet -c <(echo "505e70834d35383537b6491e7ae8641f1a4bed1876dbfe361201fc80868d88ca  libpng-1.6.37.tar.xz") || exit
#curl -L -O "https://downloads.sourceforge.net/sourceforge/libpng-apng/libpng-1.6.37-apng.patch.gz"
#sha256sum --quiet -c <(echo "823bb2d1f09dc7dae4f91ff56d6c22b4b533e912cbd6c64e8762255e411100b6  libpng-1.6.37-apng.patch.gz") || exit
#tar -xf libpng-1.6.37.tar.xz
#cd libpng-1.6.37
#gzip -cd ../libpng-1.6.37-apng.patch.gz | patch -Np1
#./configure --disable-static
#make $MAKEFLAGS
#make install
#popd

# replaced with system package
# qt5:
#mkdir /home/openmwbuild/deps/qt5
#pushd /home/openmwbuild/deps/qt5
#curl -L -O https://download.qt.io/official_releases/qt/5.15/5.15.0/submodules/qtbase-everywhere-src-5.15.0.tar.xz
#sha256sum --quiet -c <(echo "9e7af10aece15fa9500369efde69cb220eee8ec3a6818afe01ce1e7d484824c5  qtbase-everywhere-src-5.15.0.tar.xz") || exit
#tar -xf qtbase-everywhere-src-5.15.0.tar.xz
##curl -L -o patch1.patch "https://code.qt.io/cgit/qt/qtbase.git/patch/?id=777f2a1c"
##sha256sum --quiet -c <(echo "d7d58b2cadd6e79c3dfb69da664ecac9c95a78d6e142cb8687fce68e24a10776  patch1.patch") || exit
##curl -L -o patch2.patch "https://codereview.qt-project.org/gitweb?p=qt/qtbase.git;a=patch;h=54aa63be9b74e8de72db9efbe6809ab1a97b29a7"
##sha256sum --quiet -c <(echo "abb94453c9fe54fde4811bc5475b88796c8db1f5cd75ddc68918aff20139b1aa  patch2.patch") || exit
##curl -L -o patch3.patch "https://git.archlinux.org/svntogit/packages.git/plain/trunk/qt5-base-cflags.patch?h=packages/qt5-base"
##sha256sum --quiet -c <(echo "cf707cd970650f8b60f8897692b36708ded9ba116723ec8fcd885576783fe85c  patch3.patch") || exit
##curl -L -o patch4.patch "https://git.archlinux.org/svntogit/packages.git/plain/trunk/qtbug-74252.patch?h=packages/qt5-base"
##sha256sum --quiet -c <(echo "0c489d2faedd35670232a2c028c5c78a606ab81bb6f40f58e3cfe2bc6b6ac3b2  patch4.patch") || exit
#cd qtbase-everywhere-src-5.15.0
##patch -p1 -i ../patch1.patch
##patch -p1 -i ../patch2.patch
##patch -p1 -i ../patch3.patch
##patch -p1 -i ../patch4.patch
#./configure -prefix /usr/local -headerdir /usr/local/include/qt5 -opensource -confirm-license -qt-harfbuzz -fontconfig -no-use-gold-linker -no-mimetype-database -nomake examples -shared
#make $MAKEFLAGS
#make install
#popd

# qt5 wayland qpa:
#pushd /home/openmwbuild/deps/qt5
#curl -L -O https://download.qt.io/official_releases/qt/5.15/5.15.0/submodules/qtwayland-everywhere-src-5.15.0.tar.xz
#sha256sum --quiet -c <(echo "084133e10bfbd32a28125639660c59975f23457bba6a79b30a25802cec76a9fb  qtwayland-everywhere-src-5.15.0.tar.xz") || exit
#tar -xf qtwayland-everywhere-src-5.15.0.tar.xz
#cd qtwayland-everywhere-src-5.15.0
#qmake
#make $MAKEFLAGS
## manually generate missing wayland headers
#export LD_LIBRARY_PATH="${build_dir}/deps/qt5/qtbase-everywhere-src-5.15.0/lib/"
#export LD_LIBRARY_PATH="/home/openmwbuild/deps/qt5/qtbase-everywhere-src-5.15.0/lib/"
#./bin/qtwaylandscanner server-header src/extensions/qt-texture-sharing-unstable-v1.xml > /home/openmwbuild/deps/qt5/qtwayland-everywhere-src-5.15.0/src/compositor/qwayland-server-qt-texture-sharing-unstable-v1.h
#wayland-scanner -s server-header src/extensions/qt-texture-sharing-unstable-v1.xml /home/openmwbuild/deps/qt5/qtwayland-everywhere-src-5.15.0/src/compositor/wayland-qt-texture-sharing-unstable-v1-server-protocol.h
#make install
#popd

# replaced with system package
# qt5 tools (for linguist)
#pushd /home/openmwbuild/deps/qt5
#curl -L -O https://download.qt.io/official_releases/qt/5.15/5.15.0/submodules/qttools-everywhere-src-5.15.0.tar.xz
#sha256sum --quit -c <(echo "ddbcb49aab3a2e3672582c6e2e7bec0058feff790f67472343c79e2895e0e437  qttools-everywhere-src-5.15.0.tar.xz") || exit
#tar -xf qttools-everywhere-src-5.15.0.tar.xz
#cd qttools-everywhere-src-5.15.0
#qmake
#make $(MAKEFLAGS)
#make install

# replaced with system package
# collada
#mkdir /home/openmwbuild/deps/collada
#pushd /home/openmwbuild/deps/collada
#curl -L -O "https://github.com/rdiankov/collada-dom/archive/refs/tags/v2.5.0.tar.gz"
#sha256sum --quiet -c <(echo "3be672407a7aef60b64ce4b39704b32816b0b28f61ebffd4fbd02c8012901e0d  v2.5.0.tar.gz") || exit
#tar -xf v2.5.0.tar.gz
#cd collada-dom-2.5.0
#cmake .
#make $MAKEFLAGS
#make install
#popd

# openscenegraph:
mkdir /home/openmwbuild/deps/openscenegraph
pushd /home/openmwbuild/deps/openscenegraph
git clone https://github.com/OpenMW/osg.git osgFork
cd osgFork
git checkout 3.6
cd ..
mkdir build
cd build
#cmake -DPNG_LIBRARY="/usr/local/lib/libpng.so" -DBUILD_OSG_APPLICATIONS="OFF" -DCMAKE_BUILD_TYPE=Release ../osgFork
cmake -DBUILD_OSG_APPLICATIONS="OFF" -DCMAKE_BUILD_TYPE=Release -DOpenGL_GL_PREFERENCE="GLVND" ../osgFork
make $MAKEFLAGS
make install/strip
# The libraries need extra symlinks (symbols are linked differently)
#pushd /usr/local/lib64
#for i in ./libosg*.so.?.?.?; do ln -s $i ${i%%.?.?.?}.132; done
#ln -s ./libOpenThreads.so.?.?.? ./libOpenThreads.so.20
#popd
popd

# replaced with system package
# unshield:
#mkdir /home/openmwbuild/deps/unshield
#pushd /home/openmwbuild/deps/unshield
#curl -L -O https://github.com/twogood/unshield/archive/1.4.3.tar.gz
#sha256sum --quiet -c <(echo "aa8c978dc0eb1158d266eaddcd1852d6d71620ddfc82807fe4bf2e19022b7bab  1.4.3.tar.gz") || exit
#tar -xf 1.4.3.tar.gz
#cd unshield-1.4.3
#cmake -DCMAKE_BUILD_TYPE=Release
#make $MAKEFLAGS
#make install
#popd

# recastnavigation
mkdir /home/openmwbuild/deps/recastnavigation
pushd /home/openmwbuild/deps/recastnavigation
git clone https://github.com/recastnavigation/recastnavigation.git
cd recastnavigation
git checkout v1.6.0
cmake -DCMAKE_BUILD_TYPE=Release -DBUILD_SHARED_LIBS=ON -DRECASTNAVIGATION_DEMO=OFF -DRECASTNAVIGATION_TESTS=OFF -DRECASTNAVIGATION_EXAMPLES=OFF .
make $MAKEFLAGS
make install
popd

# luajit
#mkdir /home/openmwbuild/deps/luajit
#pushd /home/openmwbuild/deps/luajit
#curl -L -O https://luajit.org/download/LuaJIT-2.0.5.tar.gz
#sha256sum --quiet -c <(echo "874b1f8297c697821f561f9b73b57ffd419ed8f4278c82e05b48806d30c1e979  LuaJIT-2.0.5.tar.gz") || exit
#tar -xf LuaJIT-2.0.5.tar.gz
#cd LuaJIT-2.0.5
#make amalg
#make install
#popd

# replaced with system package
# luajit
#mkdir /home/openmwbuild/deps/luajit
#pushd /home/openmwbuild/deps/luajit
#curl -L -O https://luajit.org/download/LuaJIT-2.1.0-beta3.tar.gz
#sha256sum --quiet -c <(echo "1ad2e34b111c802f9d0cdf019e986909123237a28c746b21295b63c9e785d9c3  LuaJIT-2.1.0-beta3.tar.gz") || exit
#tar -xf LuaJIT-2.1.0-beta3.tar.gz
#cd LuaJIT-2.1.0-beta3
#make amalg XCFLAGS=-DLUAJIT_ENABLE_GC64
#make install
#popd

# replaced with system package
#yaml-cpp
#mkdir /home/openmwbuild/deps/yaml-cpp
#pushd /home/openmwbuild/deps/yaml-cpp
#curl -L -O https://github.com/jbeder/yaml-cpp/archive/yaml-cpp-0.7.0.tar.gz
#curl -L -O https://patch-diff.githubusercontent.com/raw/jbeder/yaml-cpp/pull/1037.patch
#sha512sum --quiet -c <(echo "2de0f0ec8f003cd3c498d571cda7a796bf220517bad2dc02cba70c522dddde398f33cf1ad20da251adaacb2a07b77844111f297e99d45a7c46ebc01706bbafb5 yaml-cpp-0.7.0.tar.gz") || exit
#sha512sum --quiet -c <(echo "c20d5e9393496052c3326d78555345b83a2345831d4cbfec8cf50f9576f2731ddc456148815b23dba3765b61a1a69b0c05c9618f91751dad124dbe8f7ca19609 1037.patch") || exit
#tar -xf yaml-cpp-0.7.0.tar.gz
#cd yaml-cpp-yaml-cpp-0.7.0
#patch -Np1 -i ../1037.patch
#cmake -Bbuild  -DBUILD_SHARED_LIBS=ON -DYAML_BUILD_SHARED_LIBS=ON -DCMAKE_BUILD_TYPE=Release
#cd build
#make
#make install
#popd

# make sure all installed libs are stripped
strip /usr/lib/libMyGUI*.so
strip /usr/local/lib{,64}/*.so
strip /usr/local/lib{,64}/*.so.*
strip /usr/local/lib/osgPlugins-*/*.so

# openmw (testbuild):
# needs openmw source with targz package patch at /home/openmwbuild/openmw
# make sure to source /opt/rh/devtoolset-11/enable in current shell
#mkdir /home/openmwbuild/build
#pushd /home/openmwbuild/build
#cmake -DBUILD_TGZ="ON" -DTGZ_RC="ON" -DOPENMW_VERSION="0.47.0" -DTGZ_RC_VERSION="1" -DCMAKE_BUILD_TYPE="Release" -DCPACK_STRIP_FILES="1" -DBUILD_ESMTOOL="ON" -DBUILD_BSATOOL="ON" -DBUILD_NIFTEST="ON" -DDESIRED_QT_VERSION=5 -DOPENMW_USE_SYSTEM_RECASTNAVIGATION=ON ../openmw/
#make $MAKEFLAGS
#make package
