TODAY=$(date +%Y%m%d)
YESTERDAY=$(date --date "now -1 day" +%Y%m%d)

# do not keep last 2 nightlys by making 
# grep -v not match anything since the 
# dates do not contain spaces
if [ "$1" = "all" ]
then
  TODAY=" "
  YESTERDAY=" "
fi

toscrub=$(echo "nightly"* | sed "s/ /\n/g" | grep -v "$TODAY" | grep -v "$YESTERDAY" | sed "s/ /\n/g")

#echo "$toscrub"

for nightly in $toscrub
do
  if [ ! -z "$nightly" -a -d "./$nightly" ];
  then
    #echo "$nightly is a directory"
    rm -r "./$nightly"
  fi
done
