#!/bin/sh
if [ "$1" = "" ]
then
  echo "No Build Directory given."
exit
fi

BUILDARGS=$(cat ./buildargs)
echo "BUILDARGS: $BUILDARGS"

if [ -d $1 ]
then
  echo "Directory ${1} already exists aborting. "
exit
fi

mkdir $1
cd $1

PKG_CONFIG_PATH="/usr/local/lib64/pkgconfig:/usr/local/share/pkgconfig/:/usr/local/lib/pkgconfig/:/usr/lib/pkgconfig";export PKG_CONFIG_PATH

cmake -DBUILD_TGZ=ON ${BUILDARGS} \
../openmw 2>&1 | tee cmake_log_qt5.log
make -j 2 2>&1 | tee make-qt5.log 
make package 2>&1 | tee makepkg.log 

# create debug archive if .debug binaries exist
ls -1 ./*.debug 2>/dev/null >/dev/null
ret=$?

if [ $ret -eq 0 ]
then
    echo "creating debug files targz archive"
    OPENMW_VERSION=$(cat ../buildargs | sed -e "s/^.*OPENMW_VERSION=//" -e "s/ .*//")
    IS_RC=$(cat ../buildargs | grep -c "RC_VERSION=")

    # assume release if rc version is empty/not set
    if [ "${IS_RC}" -lt 1 ]
    then
        mkdir "openmw-${OPENMW_VERSION}-Linux-64Bit"
        mv ./*.debug "openmw-${OPENMW_VERSION}-Linux-64Bit/"

        tar -czvf ../openmw-${OPENMW_VERSION}-Linux-64Bit-debug.tar.gz "openmw-${OPENMW_VERSION}-Linux-64Bit"

        mv "openmw-${OPENMW_VERSION}-Linux-64Bit/"*.debug .
        rmdir "openmw-${OPENMW_VERSION}-Linux-64Bit/"
    else
        RC_VERSION=$(cat ../buildargs | sed -e "s/^.*RC_VERSION=//" -e "s/ .*//")
        mkdir "openmw-${OPENMW_VERSION}-Linux-64BitRC${RC_VERSION}"
        mv ./*.debug "openmw-${OPENMW_VERSION}-Linux-64BitRC${RC_VERSION}/"

        tar -czvf ../openmw-${OPENMW_VERSION}-Linux-64BitRC${RC_VERSION}-debug.tar.gz "openmw-${OPENMW_VERSION}-Linux-64BitRC${RC_VERSION}"

        mv "openmw-${OPENMW_VERSION}-Linux-64BitRC${RC_VERSION}/"*.debug .
        rmdir "openmw-${OPENMW_VERSION}-Linux-64BitRC${RC_VERSION}/"
    fi
fi
