#!/bin/bash

PATH="/usr/local/bin:/usr/bin:/usr/local/sbin:/usr/sbin"

# Set to directory containing the targz build environment
TARGZENV=""

if [ "x$TARGZENV" == "x" ]
then
  echo "Build environment path not set"
  exit 1
fi

if [ ! -d "x$TARGZENV" ]
then
  echo "Build environment path $TARGZENV is not a directory"
  exit 1
fi

# Uncomment to disable nightlies (without removing crontab entry)
#exit 0

pushd $TARGZENV

# Run nightly creation script
./openmwnightly.sh > /dev/null 2> /dev/null

popd

# Calculate SHA256SUMS and SHA512SUMS
pushd /var/www/html/openmw/nightly/
#sha256sum openmw-*.tar.gz > SHA256SUMS
#sha512sum openmw-*.tar.gz > SHA512SUMS

newfiles=$(ls -t -1 openmw-*.tar.gz | grep -v -f <(cat SHA256SUMS | cut -d' ' -f 3))
if [ "x$newfiles" != "x" ]
then
    sha256sum $newfiles >> SHA256SUMS
    sha512sum $newfiles >> SHA512SUMS
fi
popd

pushd /var/www/html/openmw/source/nightly/
#sha256sum openmw-*.tar.gz > SHA256SUMS
#sha512sum openmw-*.tar.gz > SHA512SUMS

newfiles=$(ls -t -1 openmw-*.tar.gz | grep -v -f <(cat SHA256SUMS | cut -d' ' -f 3))
if [ "x$newfiles" != "x" ]
then
    sha256sum $newfiles >> SHA256SUMS
    sha512sum $newfiles >> SHA512SUMS
fi
popd
