#!/bin/sh
if [ "$1" = "" ]
then
  echo "No Build Directory given."
exit
fi

BUILDARGS=$(cat ./buildargs)
echo "BUILDARGS: $BUILDARGS"

if [ -d $1 ]
then
  echo "Directory ${1} already exists aborting. "
exit
fi

PREFIX="/home/kfg/centos6_64/home/openmwnightly"

PKG_CONFIG_PATH="/usr/local/lib64/pkgconfig:/usr/local/share/pkgconfig/:/usr/local/lib/pkgconfig/:/usr/lib/pkgconfig";export PKG_CONFIG_PATH

mkdir $1
cd $1
cmake -DBUILD_TGZ=ON ${BUILDARGS} \
../openmw 2>&1 | tee cmake_log.log
make -j 4 2>&1 | tee make.log 
make package 2>&1 | tee makepkg.log 
