#!/bin/sh
if [ "$1" = "" ]
then
  echo "No Build Directory given."
exit
fi

BUILDARGS=$(cat ./buildargs)
echo "BUILDARGS: $BUILDARGS"

if [ -d $1 ]
then
  echo "Directory ${1} already exists aborting. "
exit
fi

PREFIX="/home/kfg/centos6_64/home/openmwnightly"

PKG_CONFIG_PATH="/usr/local/lib64/pkgconfig:/usr/local/share/pkgconfig/:/usr/local/lib/pkgconfig/:/usr/lib/pkgconfig";export PKG_CONFIG_PATH

mkdir $1
cd $1
PATH="/usr/local/qt4/bin:$PATH" PKG_CONFIG_PATH="/usr/local/qt4/lib/pkgconfig:$PKG_CONFIG_PATH" cmake -DBUILD_TGZ=ON -DDESIRED_QT_VERSION=4 ${BUILDARGS} \
../openmw 2>&1 | tee cmake_log.log
make -j 4 2>&1 | tee make.log 
rm CMakeCache.txt
rm -r CMakeFiles
rm -r apps
rm -r components
cmake -DBUILD_TGZ=ON -DDESIRED_QT_VERSION=5 ${BUILDARGS} \
../openmw 2>&1 | tee cmake_log_qt5.log
make -j 4 2>&1 | tee make-qt5.log 
make package 2>&1 | tee makepkg.log 
