#!/bin/sh
if [ "$1" = "" ]
then
  echo "No Build Directory given."
exit
fi

BUILDARGS=$(cat ./buildargs)
echo "BUILDARGS: $BUILDARGS"

if [ -d $1 ]
then
  echo "Directory ${1} already exists aborting. "
exit
fi

PREFIX="/home/kfg/centos6_64/home/openmwbuild"

#seems like this is not necessary anymore
#NEWLIBS="-DBOOST_ROOT=/home/kfg/i386lucid/home/kfg/boost/build -DBoost_ADDITIONAL_VERSIONS=\"1.53 1.53.0\" -DBoost_NO_SYSTEM_PATH=TRUE -DBoost_USE_MULTITHREADED=OFF -DOGRE_HOME=/home/kfg/i386lucid/home/kfg/ogre/build/"

mkdir $1
cd $1
#SDL2DIR="/home/kfg/i386lucid/home/kfg/sdl2/build" cmake -DBUILD_TGZ="ON" -DBUILD_ESMTOOL="OFF" -DUSE_FFMPEG="ON" ${NEWLIBS} ${BUILDARGS} ../openmw
#cmake -DBUILD_TGZ=ON -DBUILD_ESMTOOL=OFF -DUSE_FFMPEG=ON ${BUILDARGS} \
#-DCMAKE_C_FLAGS_RELEASE="-O1 -fthread-jumps -falign-functions -falign-jumps -falign-loops -falign-labels -fcse-follow-jumps -fcse-skip-blocks -fdelete-null-pointer-checks -fdevirtualize -fexpensive-optimizations -fgcse -fgcse-lm -finline-small-functions -findirect-inlining -fipa-cp -fipa-sra -foptimize-sibling-calls -foptimize-strlen -fpartial-inlining -fpeephole2 -freorder-blocks-and-partition -freorder-functions -frerun-cse-after-loop -fsched-interblock -fsched-spec -fschedule-insns -fschedule-insns2 -fstrict-aliasing -fstrict-overflow -ftree-builtin-call-dce -ftree-switch-conversion -ftree-tail-merge -ftree-pre -ftree-vrp -finline-functions -funswitch-loops -fpredictive-commoning -fgcse-after-reload -ftree-vectorize -fvect-cost-model -fipa-cp-clone -DNDEBUG" \
#-DCMAKE_CXX_FLAGS_RELEASE="-O1 -fthread-jumps -falign-functions -falign-jumps -falign-loops -falign-labels -fcse-follow-jumps -fcse-skip-blocks -fdelete-null-pointer-checks -fdevirtualize -fexpensive-optimizations -fgcse -fgcse-lm -finline-small-functions -findirect-inlining -fipa-cp -fipa-sra -foptimize-sibling-calls -foptimize-strlen -fpartial-inlining -fpeephole2 -freorder-blocks-and-partition -freorder-functions -frerun-cse-after-loop -fsched-interblock -fsched-spec -fschedule-insns -fschedule-insns2 -fstrict-aliasing -fstrict-overflow -ftree-builtin-call-dce -ftree-switch-conversion -ftree-tail-merge -ftree-pre -ftree-vrp -finline-functions -funswitch-loops -fpredictive-commoning -fgcse-after-reload -ftree-vectorize -fvect-cost-model -fipa-cp-clone -DNDEBUG" \

PKG_CONFIG_PATH="/usr/local/lib/pkgconfig/:/usr/lib/pkgconfig";export PKG_CONFIG_PATH

cmake -DBUILD_TGZ=ON -DBUILD_ESMTOOL=OFF -DUSE_FFMPEG=ON ${BUILDARGS} \
../openmw 2>&1 | tee cmake_log.log
make -j 4 2>&1 | tee make.log 
rm CMakeCache.txt
rm -r CMakeFiles
rm -r apps
rm -r components
cmake -DBUILD_TGZ=ON -DBUILD_ESMTOOL=OFF -DUSE_FFMPEG=ON -DDESIRED_QT_VERSION=5 ${BUILDARGS} \
../openmw 2>&1 | tee cmake_log_qt5.log
make -j 4 2>&1 | tee make-qt5.log 
make package 2>&1 | tee makepkg.log 
